<?php

use Illuminate\Support\Facades\Route;
use Modules\ZimflowApi\Http\Controllers\Admin\ZimflowConfigController; // Make sure this path is correct

/*
|--------------------------------------------------------------------------
| Admin Routes for ZimflowApi Module
|--------------------------------------------------------------------------
|
| Routes defined here will be prefixed with 'admin/zimflowapi'
| and named with 'admin.zimflowapi.' by the main RouteServiceProvider.
|
*/

// Example: Route for editing Zimflow API configuration
Route::get('config', [ZimflowConfigController::class, 'edit'])->name('config.edit');

// This is the route that was missing:
Route::put('config', [ZimflowConfigController::class, 'update'])->name('config.update');
Route::post('config/test-notification', [ZimflowConfigController::class, 'sendTestNotification'])->name('config.testNotification');