@extends('layouts.admin')

@section('title', 'Zimflow Gateway Configuration')
@section('header_title', 'Zimflow Gateway Settings')

@section('content')
<div class="bg-white dark:bg-gray-800 shadow-xl rounded-xl overflow-hidden">
    <div class="px-6 py-5 border-b border-gray-200 dark:border-gray-700">
        <h3 class="text-lg leading-6 font-medium text-gray-900 dark:text-gray-100">
            Zimflow API Configuration
        </h3>
        <p class="mt-1 text-sm text-gray-500 dark:text-gray-400">
            Configure your Zimflow API token and endpoint. These settings can also be set in your <code>.env</code> file.
        </p>
    </div>
    <form action="{{ route('admin.zimflowapi.config.update') }}" method="POST">
        @csrf
        @method('PUT')
        <div class="px-6 py-6 space-y-6">
            <div>
                <label for="zimflow_notifications_enabled" class="flex items-center">
                    <input type="checkbox" name="zimflow_notifications_enabled" id="zimflow_notifications_enabled" value="1"
                           {{ old('zimflow_notifications_enabled', $settings['zimflow_notifications_enabled'] ?? '0') == '1' ? 'checked' : '' }}
                           class="rounded border-gray-300 dark:border-gray-600 text-indigo-600 shadow-sm focus:ring-indigo-500 dark:bg-gray-700 dark:focus:ring-indigo-600 dark:focus:ring-offset-gray-800">
                    <span class="ml-2 text-sm text-gray-600 dark:text-gray-400">Enable Zimflow Notifications</span>
                </label>
                @error('zimflow_notifications_enabled') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
            </div>

            <div>
                <label for="zimflow_api_endpoint" class="block text-sm font-medium text-gray-700 dark:text-gray-300">API Endpoint</label>
                <input type="url" name="zimflow_api_endpoint" id="zimflow_api_endpoint"
                       value="{{ old('zimflow_api_endpoint', $settings['zimflow_api_endpoint'] ?? '') }}"
                       placeholder="e.g., https://zimflow.co.zw/" required
                       class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 focus:border-indigo-500 dark:focus:border-indigo-600 focus:ring-indigo-500 dark:focus:ring-indigo-600 rounded-md shadow-sm">
                @error('zimflow_api_endpoint') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
            </div>

            <div>
                <label for="zimflow_api_token" class="block text-sm font-medium text-gray-700 dark:text-gray-300">API Token</label>
                <input type="text" name="zimflow_api_token" id="zimflow_api_token"
                       value="{{ old('zimflow_api_token', $settings['zimflow_api_token'] ?? '') }}"
                       placeholder="Enter your Zimflow API Token" required
                       class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 focus:border-indigo-500 dark:focus:border-indigo-600 focus:ring-indigo-500 dark:focus:ring-indigo-600 rounded-md shadow-sm">
                @error('zimflow_api_token') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
            </div>
        </div>
        <div class="px-6 py-4 bg-gray-50 dark:bg-gray-700/50 text-right">
            <button type="submit" class="inline-flex justify-center py-2 px-4 border border-transparent shadow-sm text-sm font-medium rounded-md text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 dark:focus:ring-offset-gray-800">
                Save Settings
            </button>
        </div>
    </form>

    <div class="mt-8 border-t border-gray-200 dark:border-gray-700">
        <div class="px-6 py-5">
            <h3 class="text-lg leading-6 font-medium text-gray-900 dark:text-gray-100">
                Test Zimflow Notification
            </h3>
            <p class="mt-1 text-sm text-gray-500 dark:text-gray-400">
                Send a test WhatsApp message to verify your Zimflow API configuration.
                Ensure your settings above are saved first.
            </p>
        </div>
        <form action="{{ route('admin.zimflowapi.config.testNotification') }}" method="POST">
            @csrf
            <div class="px-6 py-6 space-y-6">
                <div>
                    <label for="test_recipient_number" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Test Recipient WhatsApp Number</label>
                    <input type="text" name="test_recipient_number" id="test_recipient_number"
                           value="{{ old('test_recipient_number', setting('zimflow_test_recipient_number') ?? '') }}"
                           placeholder="e.g., 26377xxxxxxx (international format)" required
                           class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 focus:border-indigo-500 dark:focus:border-indigo-600 focus:ring-indigo-500 dark:focus:ring-indigo-600 rounded-md shadow-sm">
                    @error('test_recipient_number') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
                </div>
            </div>
            <div class="px-6 py-4 bg-gray-50 dark:bg-gray-700/50 text-right">
                <button type="submit" class="inline-flex justify-center py-2 px-4 border border-transparent shadow-sm text-sm font-medium rounded-md text-white bg-green-600 hover:bg-green-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-green-500 dark:focus:ring-offset-gray-800">
                    Send Test Notification
                </button>
            </div>
        </form>
    </div>
</div>
@endsection
