<?php

namespace Modules\ZimflowApi\Providers;

use Illuminate\Foundation\Support\Providers\RouteServiceProvider as ServiceProvider;
use Illuminate\Support\Facades\Route;

class RouteServiceProvider extends ServiceProvider
{
    protected string $name = 'ZimflowApi';

    /** @var string The module namespace to assume when generating URLs to actions. */
    protected string $moduleNamespace = 'Modules\ZimflowApi\Http\Controllers';

    /**
     * Called before routes are registered.
     *
     * Register any model bindings or pattern based filters.
     */
    public function boot(): void
    {
        parent::boot();
    }

    /**
     * Define the routes for the application.
     */
    public function map(): void
    {
        $this->mapApiRoutes();
        $this->mapWebRoutes();
    }

    /**
     * Define the "web" routes for the application.
     *
     * These routes all receive session state, CSRF protection, etc.
     */
    protected function mapWebRoutes(): void
    {
        // The main app's RouteServiceProvider already applies the 'web' middleware.
        // This ensures controllers in web.php are correctly namespaced.
        Route::middleware('web') // Ensures the group call is valid and context is clear
            ->namespace($this->moduleNamespace)
            ->group(module_path($this->name, '/routes/web.php'));
    }

    /**
     * Define the "api" routes for the application.
     *
     * These routes are typically stateless.
     */
    protected function mapApiRoutes(): void
    {
        // The main app's RouteServiceProvider applies 'api' middleware,
        // 'api/zimflowapi' prefix, 'api.zimflowapi.' name prefix,
        // and the base 'Modules\ZimflowApi\Http\Controllers' namespace.
        // This method ensures controllers in api.php are correctly namespaced
        // relative to $this->moduleNamespace.
        Route::namespace($this->moduleNamespace) // Assumes API controllers are in the root of Http/Controllers for this module
            ->group(module_path($this->name, '/routes/api.php'));
    }
}
