# SyndicateSave Module

## Description

The SyndicateSave module provides a comprehensive platform for managing group savings schemes (Mukando/Chama/Stokvel), internal loan management, group-based income generation projects, and micro-insurance functionalities. It aims to empower communities and groups by digitizing traditional financial collaboration with modern fintech capabilities, including the potential for virtual credit card integration.

## Core Features

*   **Group Management:** Create, join, and manage syndicate groups with configurable rules and member roles.
*   **Contribution Management:** Define and track member contributions with automated reminders and transparent ledgers.
*   **Payout Management:** Flexible and configurable payout systems (round-robin, bidding, etc.).
*   **Internal Loan Management:** Syndicate groups can offer loans to members with configurable terms, interest rates, and automated repayment tracking.
*   **Income Generation Projects:** Facilitate group investments and profit/loss sharing for internal projects.
*   **Micro-Insurance (Basic):** Allow groups to set up simple welfare or insurance-like funds.
*   **Virtual Credit Card Integration (Advanced):** Potential to integrate with VCC providers for group or member spending.
*   **Financial Reporting:** Detailed statements and reports for groups and individual members.
*   **Communication Tools:** In-app messaging and automated notifications.
*   **Security & Audit:** Role-based access, transaction approvals, and comprehensive audit trails.
*   **Payment Gateway Integration:** Seamless collection of contributions and loan repayments.

## Installation & Setup

1.  Ensure the module is enabled in your main application's module configuration (usually `config/modules.php` or by ensuring its entry in `modules_statuses.json` is `true`).
2.  Run migrations: `php artisan module:migrate SyndicateSave`
3.  Run seeders (if any are created): `php artisan module:seed SyndicateSave`
4.  Configure necessary settings in the Admin Panel under SyndicateSave settings (e.g., default loan parameters, notification preferences).
5.  If VCC functionality is used, configure API credentials for the chosen VCC provider.

## Key Functionalities

*   **Syndicate Creation:** Users can create new syndicates, defining rules, contribution schedules, and payout methods.
*   **Member Contributions:** Members make contributions to their syndicate's wallet.
*   **Loan Application & Processing:** Members can apply for loans from their syndicate's funds, subject to group approval.
*   **Project Funding:** Syndicates can fund income-generating projects proposed by members.
*   **Financial Oversight:** Treasurers and group admins manage funds, track transactions, and generate reports.

## User Roles

*   **System Admin:** Oversees the module, manages global settings.
*   **Syndicate Admin/Creator:** Manages a specific syndicate, its members, rules, and approves transactions.
*   **Syndicate Treasurer (Optional Role):** Manages financial records and confirms manual payments for a syndicate.
*   **Syndicate Member:** Participates in contributions, payouts, can apply for loans, and propose projects.

## Integration Points

*   **Payment Gateways (Paypal, Paystack, Stripe):** Used for online collection of contributions and loan repayments. Syndicates can be configured to use their own gateway credentials. This module will check for the presence and activation of `PaypalGateway`, `PaystackGateway`, and `StripeGateway` modules to offer these payment options.
*   **User Module:** Relies on the main application's user authentication and profiles.
*   **Notification System:** Leverages the application's notification channels (email, SMS, in-app).
*   **BusinessDirectory Module (Optional):** If a syndicate undertakes an e-commerce project, it might leverage product/shop features from the `BusinessDirectory` module.

## Future Enhancements

*   Advanced KYC/AML features.
*   Direct integration with bank accounts for disbursements.
*   Mobile application support.
*   More sophisticated risk assessment tools for loans.
*   Gamification elements for savings and contributions.
*   Integration with accounting software.