<?php

use Illuminate\Support\Facades\Route;
use Modules\StripeGateway\Http\Controllers\StripeSubscriptionController;
use Modules\StripeGateway\Http\Controllers\StripeWebhookController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the ServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

// Webhook - should generally be exempt from CSRF if not already handled by VerifyCsrfToken exceptions
Route::post('webhooks/stripe', [StripeWebhookController::class, 'handleWebhook'])->name('webhooks.stripe.handle');


Route::middleware(['web', 'auth']) // User must be authenticated
     ->prefix('subscribe/stripe')
     ->name('subscription.stripe.') // Changed name for consistency
     ->group(function () {
         // The {subscriptionPlan:slug} will use route model binding if your SubscriptionPlan model uses 'slug' as its route key name
         Route::post('checkout/{subscriptionPlan:slug}', [StripeSubscriptionController::class, 'checkout'])->name('checkout');
         Route::get('success', [StripeSubscriptionController::class, 'handleSuccess'])->name('success');
         Route::get('cancel', [StripeSubscriptionController::class, 'handleCancel'])->name('cancel');
         Route::post('portal', [StripeSubscriptionController::class, 'redirectToCustomerPortal'])->name('customer.portal');
         Route::post('cancel-active', [StripeSubscriptionController::class, 'cancelActiveSubscription'])->name('cancel.active');
     });

Route::middleware(['web', 'auth'])
     ->prefix('wallet/stripe')
     ->name('wallet.stripe.')
     ->group(function () {
         // Note: The WalletController redirects to this route with amount in POST/GET
         Route::match(['get', 'post'], 'initialize-deposit', [StripeSubscriptionController::class, 'initializeWalletDeposit'])->name('initializeDeposit');
         Route::get('deposit-success', [StripeSubscriptionController::class, 'handleWalletDepositSuccess'])->name('depositSuccess');
         Route::get('deposit-cancel', [StripeSubscriptionController::class, 'handleWalletDepositCancel'])->name('depositCancel');
     });
