@extends('layouts.admin') {{-- Use your admin layout --}}

@section('title', 'Stripe Gateway Settings')
@section('header_title', 'Stripe Gateway Configuration')

@section('content')
<div class="bg-white dark:bg-gray-800 overflow-hidden shadow-xl sm:rounded-lg">
    <div class="p-6 lg:p-8">
        <h1 class="text-2xl font-medium text-gray-900 dark:text-white mb-6">
            Stripe Settings
        </h1>

        @include('admin.partials.alerts') {{-- For success/error messages --}}

        <form action="{{ route('admin.stripegateway.settings.update') }}" method="POST">
            @csrf
            @method('POST') {{-- Changed from PUT to POST to match route definition --}}

            <div class="space-y-6">
                <!-- Enable Stripe -->
                <div>
                    @php
                        $id = 'stripe_enabled';
                        $name = 'stripe_enabled';
                        $label = 'Enable Stripe Gateway';
                        $value = '1';
                        $checked = old('stripe_enabled', $settings['stripe_enabled'] ?? '0') == '1';
                        $helpText = 'Toggle this to activate or deactivate the Stripe payment gateway.';
                    @endphp
                    <label for="{{ $id }}" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">{{ $label }}</label>
                    <label class="relative inline-flex items-center cursor-pointer mt-1">
                        <input type="checkbox" id="{{ $id }}" name="{{ $name }}" class="sr-only peer" value="{{ $value }}" {{ $checked ? 'checked' : '' }}>
                        <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-blue-300 dark:peer-focus:ring-blue-800 rounded-full peer dark:bg-gray-700 peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all dark:border-gray-600 peer-checked:bg-blue-600"></div>
                    </label>
                    @if($helpText)
                        <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">{{ $helpText }}</p>
                    @endif
                    @error($name) <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                </div>

                <!-- Stripe Publishable Key -->
                <div>
                    <label for="stripe_publishable_key" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Stripe Publishable Key</label>
                    <input type="text" name="stripe_publishable_key" id="stripe_publishable_key" value="{{ old('stripe_publishable_key', $settings['stripe_publishable_key'] ?? '') }}"
                           class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 focus:border-indigo-500 dark:focus:border-indigo-600 focus:ring-indigo-500 dark:focus:ring-indigo-600 rounded-md shadow-sm">
                    @error('stripe_publishable_key') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                </div>

                <!-- Stripe Secret Key -->
                <div>
                    <label for="stripe_secret_key" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Stripe Secret Key</label>
                    <input type="password" name="stripe_secret_key" id="stripe_secret_key" value=""
                           class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 focus:border-indigo-500 dark:focus:border-indigo-600 focus:ring-indigo-500 dark:focus:ring-indigo-600 rounded-md shadow-sm"
                           placeholder="Leave blank to keep current secret">
                    <p class="text-xs text-gray-500 dark:text-gray-400 mt-1">Enter a new secret key to update it. Leave blank to keep the existing one.</p>
                    @error('stripe_secret_key') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                </div>

                <!-- Stripe Webhook Signing Secret -->
                <div>
                    <label for="stripe_webhook_secret" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Stripe Webhook Signing Secret</label>
                    <input type="password" name="stripe_webhook_secret" id="stripe_webhook_secret" value=""
                           class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 focus:border-indigo-500 dark:focus:border-indigo-600 focus:ring-indigo-500 dark:focus:ring-indigo-600 rounded-md shadow-sm"
                           placeholder="Leave blank to keep current secret">
                    <p class="text-xs text-gray-500 dark:text-gray-400 mt-1">Enter a new webhook secret to update it. Leave blank to keep the existing one.</p>
                    @error('stripe_webhook_secret') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                </div>

                <!-- Stripe Mode -->
                <div>
                    @php
                        $id_mode = 'stripe_mode';
                        $name_mode = 'stripe_mode';
                        $label_mode = 'Stripe Mode';
                        $current_mode = old('stripe_mode', $settings['stripe_mode'] ?? 'test');
                        $options_mode = ['test' => 'Test', 'live' => 'Live'];
                        $helpText_mode = 'Select whether to use Stripe in Test or Live mode. Ensure keys match the selected mode.';
                    @endphp
                    <label for="{{ $id_mode }}" class="block text-sm font-medium text-gray-700 dark:text-gray-300">{{ $label_mode }}</label>
                    <select name="{{ $name_mode }}" id="{{ $id_mode }}" class="mt-1 block w-full pl-3 pr-10 py-2 text-base border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm rounded-md">
                        @foreach($options_mode as $value => $display)
                            <option value="{{ $value }}" {{ $current_mode == $value ? 'selected' : '' }}>{{ $display }}</option>
                        @endforeach
                    </select>
                    @if($helpText_mode)
                        <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">{{ $helpText_mode }}</p>
                    @endif
                    @error($name_mode) <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                </div>
            </div>

            <div class="mt-8 flex justify-end">
                <button type="submit"
                        class="inline-flex items-center px-4 py-2 bg-gray-800 dark:bg-gray-200 border border-transparent rounded-md font-semibold text-xs text-white dark:text-gray-800 uppercase tracking-widest hover:bg-gray-700 dark:hover:bg-white focus:bg-gray-700 dark:focus:bg-white active:bg-gray-900 dark:active:bg-gray-300 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:ring-offset-2 dark:focus:ring-offset-gray-800 transition ease-in-out duration-150">
                    Save Settings
                </button>
            </div>
        </form>
    </div>
</div>
@endsection
