# Stripe Payment Gateway Module

## Overview

This module integrates the Stripe payment gateway into the application, enabling subscription-based payments. It allows users to subscribe to plans using Stripe Checkout and provides administrators with tools to configure Stripe settings and manage subscriptions (via Stripe's Billing Portal). The module also handles webhooks from Stripe to keep local subscription statuses in sync.

## Features

-   Stripe Checkout integration for new subscriptions.
-   Management of Stripe API keys (Publishable, Secret) and Webhook Signing Secret via admin settings.
-   Creation and management of Stripe Customers.
-   Webhook handling for key subscription events (e.g., payment success, failure, subscription updates, cancellations).
-   Redirection to Stripe Customer Billing Portal for users to manage their payment methods and subscriptions.
-   Functionality for users to cancel their active Stripe subscriptions.

## Setup & Configuration

1.  **Install Dependencies:**
    Ensure the Stripe PHP SDK is installed:
    ```bash
    composer require stripe/stripe-php
    ```

2.  **Database Migrations:**
    *   The core application requires a `stripe_customer_id` column on the `users` table. If not already present, run the necessary migration:
        ```bash
        php artisan migrate
        ```
    *   (Optional but Recommended) The `subscription_plans` table can be extended with `stripe_product_id` and `stripe_price_id` columns for a more robust integration with Stripe Products and Prices.

3.  **Environment Variables (Fallback):**
    While settings are managed via the admin panel, you can have fallback values in your main `.env` file:
    ```env
    STRIPE_PUBLISHABLE_KEY=pk_test_yourpublishablekey
    STRIPE_SECRET_KEY=sk_test_yoursecretkey
    STRIPE_WEBHOOK_SECRET=whsec_yourwebhooksecret
    ```

4.  **Admin Configuration:**
    *   Navigate to `Admin Panel > Modules > Stripe Gateway Settings`.
    *   Enter your Stripe Publishable Key, Secret Key, and Webhook Signing Secret.
    *   Enable the Stripe Gateway.

5.  **Stripe Dashboard Setup:**
    *   **Products & Prices:** Create corresponding Products and Prices in your Stripe Dashboard for each subscription plan you offer in the application. If you've added `stripe_product_id` and `stripe_price_id` to your `subscription_plans` table, enter these IDs in the admin panel when creating/editing plans.
    *   **Webhook Endpoint:**
        *   In your Stripe Dashboard, go to Developers > Webhooks.
        *   Click "Add endpoint".
        *   Set the "Endpoint URL" to: `YOUR_APP_URL/webhooks/stripe` (e.g., `https://yourdomain.com/webhooks/stripe`). For local development, use a tunneling service like ngrok or Expose.
        *   Select the events to listen for. Recommended events include:
            *   `checkout.session.completed`
            *   `customer.subscription.created`
            *   `customer.subscription.updated`
            *   `customer.subscription.deleted`
            *   `invoice.payment_succeeded`
            *   `invoice.payment_failed`
        *   Retrieve the "Signing secret" for this endpoint and enter it in the module's admin settings.

6.  **CSRF Exemption:**
    Ensure the Stripe webhook route (`webhooks/stripe`) is added to the `$except` array in `app/Http/Middleware/VerifyCsrfToken.php`.

## Usage

-   Once configured and enabled, Stripe will appear as a payment option on the subscription plans page.
-   Users can subscribe via Stripe Checkout.
-   Users can manage their Stripe subscriptions (e.g., update card, cancel) via the Stripe Customer Billing Portal, accessible from their user profile.
-   Administrators can configure Stripe API keys and view subscription details (though direct subscription management is typically done via Stripe's dashboard or the customer portal).

## Webhook Handling

The module listens for Stripe webhooks to automatically update the status of local subscription records. This includes:
-   Activating subscriptions upon successful payment.
-   Updating renewal dates.
-   Marking subscriptions as past due or cancelled based on Stripe events.

It is crucial that the webhook endpoint is correctly configured in Stripe and publicly accessible.

## Customization

-   **Views:** User-facing views related to Stripe (if any beyond redirects) can be found in `Modules/StripeGateway/Resources/views/`.
-   **Controllers:** Logic for handling checkout, success/cancel redirects, and webhooks is in `Modules/StripeGateway/Http/Controllers/`.
-   **Service:** Core Stripe API interactions are encapsulated in `Modules/StripeGateway/Services/StripeService.php`.

