<?php

namespace Modules\StripeGateway\Providers;

use Illuminate\Foundation\Support\Providers\RouteServiceProvider as ServiceProvider;
use Illuminate\Support\Facades\Route;

class RouteServiceProvider extends ServiceProvider
{
    protected string $name = 'StripeGateway'; // Corrected Module name
    protected string $moduleNamespace = 'Modules\StripeGateway\Http\Controllers';

    /**
     * Called before routes are registered.
     *
     * Register any model bindings or pattern based filters.
     */
    public function boot(): void
    {
        parent::boot();
    }

    /**
     * Define the routes for the application.
     */
    public function map(): void
    {
        $this->mapWebRoutes();
        // $this->mapAdminRoutes(); // Admin routes are loaded by the main app's RouteServiceProvider
        $this->mapApiRoutes();
    }

    /**
     * Define the "web" routes for the application.
     *
     * These routes all receive session state, CSRF protection, etc.
     */
    protected function mapWebRoutes(): void
    {
        // The main app's RouteServiceProvider already applies the 'web' middleware.
        // This ensures controllers in web.php are correctly namespaced.
        Route::middleware('web') // Ensures the group call is valid and context is clear
             ->namespace($this->moduleNamespace)
             ->group(module_path($this->name, '/routes/web.php')); // Use lowercase 'routes'
    }

    /**
     * Define the "admin" routes for the application.
     */
    // protected function mapAdminRoutes(): void // This method is not needed as main RSP handles admin routes
    // {
        // The main app's RouteServiceProvider handles loading admin routes,
        // applying 'web' and 'IsAdminMiddleware', prefixing with 'admin/stripegateway',
        // naming with 'admin.stripegateway.', and namespacing to 'Modules\StripeGateway\Http\Controllers\Admin'.
    // }

    /**
     * Define the "api" routes for the application.
     */
    protected function mapApiRoutes(): void
    {
        // The main app's RouteServiceProvider applies 'api' middleware,
        // 'api/stripegateway' prefix, 'api.stripegateway.' name prefix,
        // and the base 'Modules\StripeGateway\Http\Controllers' namespace.
        // This method ensures controllers in api.php are correctly namespaced
        // relative to $this->moduleNamespace.
        Route::namespace($this->moduleNamespace) // Assuming API controllers are directly under Http/Controllers
             ->group(module_path($this->name, '/routes/api.php')); // Use lowercase 'routes'
    }
}
