@extends('layouts.admin')

@section('title', 'Paystack Gateway Settings')
@section('header_title', 'Paystack Gateway Settings')

@section('content')
<div class="bg-white dark:bg-gray-800 overflow-hidden shadow-xl sm:rounded-lg">
    <div class="p-6 lg:p-8">
        @include('admin.partials.alerts') {{-- For success/error messages --}}

        <form action="{{ route('admin.paystackgateway.settings.update') }}" method="POST">
            @csrf
            @method('PUT')

            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <!-- Enable Paystack -->
                <div class="md:col-span-2">
                     @php
                        $id = 'paystack_enabled';
                        $name = 'paystack_enabled';
                        $label = 'Enable Paystack Gateway';
                        $value = '1';
                        $checked = old('paystack_enabled', $settings['paystack_enabled'] ?? '0') == '1';
                        $helpText = 'Toggle this to activate or deactivate the Paystack payment gateway.';
                    @endphp
                    <label for="{{ $id }}" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">{{ $label }}</label>
                    <label class="relative inline-flex items-center cursor-pointer mt-1">
                        <input type="checkbox" id="{{ $id }}" name="{{ $name }}" class="sr-only peer" value="{{ $value }}" {{ $checked ? 'checked' : '' }}>
                        <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-blue-300 dark:peer-focus:ring-blue-800 rounded-full peer dark:bg-gray-700 peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all dark:border-gray-600 peer-checked:bg-blue-600"></div>
                    </label>
                    @if($helpText)
                        <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">{{ $helpText }}</p>
                    @endif
                    @error('paystack_enabled') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                </div>

                <!-- Paystack Mode -->
                <div>
                    <label for="paystack_mode" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Paystack Mode</label>
                    <select name="paystack_mode" id="paystack_mode" required
                            class="mt-1 block w-full pl-3 pr-10 py-2 text-base border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-100 focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm rounded-md">
                        <option value="test" {{ old('paystack_mode', $settings['paystack_mode'] ?? 'test') == 'test' ? 'selected' : '' }}>Test</option>
                        <option value="live" {{ old('paystack_mode', $settings['paystack_mode'] ?? '') == 'live' ? 'selected' : '' }}>Live</option>
                    </select>
                    @error('paystack_mode') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                </div>

                <div></div> {{-- Spacer for grid --}}

                <!-- Paystack Public Key -->
                <div>
                    <label for="paystack_public_key" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Paystack Public Key</label>
                    <input type="text" name="paystack_public_key" id="paystack_public_key" value="{{ old('paystack_public_key', $settings['paystack_public_key'] ?? '') }}"
                           class="mt-1 block w-full shadow-sm sm:text-sm border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-100 rounded-md focus:ring-indigo-500 focus:border-indigo-500">
                    @error('paystack_public_key') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                </div>

                <!-- Paystack Secret Key -->
                <div>
                    <label for="paystack_secret_key" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Paystack Secret Key</label>
                    <input type="password" name="paystack_secret_key" id="paystack_secret_key" value="" {{-- Value removed for security --}}
                           class="mt-1 block w-full shadow-sm sm:text-sm border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-100 rounded-md focus:ring-indigo-500 focus:border-indigo-500"
                           placeholder="Leave blank to keep current secret">
                    <p class="text-xs text-gray-500 dark:text-gray-400 mt-1">Enter a new secret to update it. Leave blank to keep the existing one.</p>
                    @error('paystack_secret_key') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                </div>

            </div>

            <div class="mt-8 flex justify-end">
                <button type="submit" class="inline-flex items-center px-4 py-2 bg-gray-800 dark:bg-gray-200 border border-transparent rounded-md font-semibold text-xs text-white dark:text-gray-800 uppercase tracking-widest hover:bg-gray-700 dark:hover:bg-white focus:bg-gray-700 dark:focus:bg-white active:bg-gray-900 dark:active:bg-gray-300 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:ring-offset-2 dark:focus:ring-offset-gray-800 transition ease-in-out duration-150">
                    Save Settings
                </button>
            </div>
        </form>
    </div>
</div>

<style>
    /* Simple toggle switch style */
    input:checked ~ .dot {
        transform: translateX(100%);
        background-color: #48bb78; /* green-500 */
    }
    input:checked ~ .block {
        background-color: #a0aec0; /* gray-400 */
    }
    /* Dark mode for toggle */
    .dark input:checked ~ .dot {
        background-color: #38a169; /* green-600 */
    }
    .dark input:checked ~ .block {
        background-color: #4a5568; /* gray-600 */
    }
</style>
@endsection