<?php

namespace Modules\PaystackGateway\Providers;

use App\Models\SubscriptionPlan; // Import your SubscriptionPlan model
use Illuminate\Foundation\Support\Providers\RouteServiceProvider as ServiceProvider;
use Illuminate\Support\Facades\Route;

class RouteServiceProvider extends ServiceProvider
{
    protected string $name = 'PaystackGateway'; // Module name
    protected string $moduleNamespace = 'Modules\PaystackGateway\Http\Controllers';

    /**
     * Called before routes are registered.
     *
     * Register any model bindings or pattern based filters.
     */
    public function boot(): void
    {
        parent::boot();

        // Explicitly bind the 'subscriptionPlan' route parameter
        // to resolve SubscriptionPlan models by 'slug' without global scopes.
        Route::bind('subscriptionPlan', function ($value) {
            // Use the model's getRouteKeyName() to be dynamic, though we know it's 'slug'
            return SubscriptionPlan::where((new SubscriptionPlan)->getRouteKeyName(), $value)
                ->withoutGlobalScopes() // Apply withoutGlobalScopes here
                ->firstOrFail();
        });
    }

    /**
     * Define the routes for the application.
     */
    public function map(): void
    {
        $this->mapWebRoutes();
        // $this->mapAdminRoutes(); // Admin routes are loaded by the main app's RouteServiceProvider by convention
        $this->mapApiRoutes();
    }

    /**
     * Define the "web" routes for the application.
     *
     * These routes all receive session state, CSRF protection, etc.
     */
    protected function mapWebRoutes(): void
    {
        // The main app's RouteServiceProvider already applies the 'web' middleware.
        // This ensures controllers in web.php are correctly namespaced.
        Route::middleware('web')
            ->namespace($this->moduleNamespace)
            ->group(module_path($this->name, 'routes/web.php'));
    }

    // protected function mapAdminRoutes(): void // This method is not needed as main RSP handles admin routes
    // {
        // The main app's RouteServiceProvider handles loading admin routes,
        // applying 'web' and 'IsAdminMiddleware', prefixing with 'admin/paystackgateway',
        // naming with 'admin.paystackgateway.', and namespacing to 'Modules\PaystackGateway\Http\Controllers\Admin'.
    // }

    /**
     * Define the "api" routes for the application.
     */
    protected function mapApiRoutes(): void
    {
        // The main app's RouteServiceProvider applies 'api' middleware,
        // 'api/paystackgateway' prefix, 'api.paystackgateway.' name prefix,
        // and the base 'Modules\PaystackGateway\Http\Controllers' namespace.
        Route::namespace($this->moduleNamespace) // Assuming API controllers are directly under Http/Controllers
            ->group(module_path($this->name, 'routes/api.php'));
    }
}
