<?php

namespace Modules\PaystackGateway\Providers;

use Illuminate\Support\ServiceProvider;
use Modules\PaystackGateway\Services\PaystackService; // Import the service
use Illuminate\Support\Facades\Blade;
use Nwidart\Modules\Traits\PathNamespace;

class PaystackGatewayServiceProvider extends ServiceProvider
{
    /**
     * @var string $moduleName
     */
    protected string $moduleName = 'PaystackGateway';

    /**
     * @var string $moduleNameLower
     */
    protected string $moduleNameLower = 'paystackgateway';

    use PathNamespace; // Add this trait

    public function boot(): void
    {
        $this->registerConfig();
        $this->loadMigrationsFrom(module_path($this->moduleName, 'Database/Migrations'));
        $this->registerViews();      // Uncomment and implement this
        $this->registerTranslations(); // Uncomment and implement if you have translations
        // Route loading is handled by the main app's RouteServiceProvider loop for modules.
        // $this->loadRoutesFrom(module_path($this->moduleName, 'Routes/web.php'));
        // $this->loadRoutesFrom(module_path($this->moduleName, 'Routes/admin.php'));
        // $this->loadRoutesFrom(module_path($this->moduleName, 'Routes/api.php'));
    }

// In Modules\PaystackGateway\Providers\PaystackGatewayServiceProvider.php
public function register(): void
{    
    $this->app->register(EventServiceProvider::class); // Register the module's EventServiceProvider
    $this->app->register(RouteServiceProvider::class); // Register the module's RouteServiceProvider

    $this->app->singleton(PaystackService::class, function ($app) {
        return new PaystackService();
    });
}


    protected function registerConfig(): void
    {
        $this->publishes([
            module_path($this->moduleName, 'config/config.php') => config_path($this->moduleNameLower . '.php'),
        ], 'config');
        $this->mergeConfigFrom(
            module_path($this->moduleName, 'config/config.php'), $this->moduleNameLower
        );
    }

    public function registerViews(): void
    {
        $viewPath = resource_path('views/modules/'.$this->moduleNameLower);
        $sourcePath = module_path($this->moduleName, 'resources/views');

        $this->publishes([$sourcePath => $viewPath], ['views', $this->moduleNameLower.'-module-views']);

        $this->loadViewsFrom(array_merge($this->getPublishableViewPaths(), [$sourcePath]), $this->moduleNameLower);

        Blade::componentNamespace(config('modules.namespace').'\\' . $this->moduleName . '\\View\\Components', $this->moduleNameLower);
    }

    public function registerTranslations(): void
    {
        $langPath = resource_path('lang/modules/' . $this->moduleNameLower);

        if (is_dir($langPath)) {
            $this->loadTranslationsFrom($langPath, $this->moduleNameLower);
            $this->loadJsonTranslationsFrom($langPath);
        } else {
            $this->loadTranslationsFrom(module_path($this->moduleName, 'lang'), $this->moduleNameLower);
            $this->loadJsonTranslationsFrom(module_path($this->moduleName, 'lang'));
        }
    }

    public function provides(): array
    {
        return [];
    }

    private function getPublishableViewPaths(): array
    {
        $paths = [];
        foreach (config('view.paths') as $path) {
            if (is_dir($path.'/modules/'.$this->moduleNameLower)) {
                $paths[] = $path.'/modules/'.$this->moduleNameLower;
            }
        }
        return $paths;
    }
}