# PayPal Payment Gateway Module

## Overview

This module integrates the PayPal payment gateway into the application, enabling subscription-based payments. It allows users to subscribe to plans using PayPal's Subscriptions API and provides administrators with tools to configure PayPal settings. The module also handles webhooks from PayPal to keep local subscription statuses in sync.

## Features

-   PayPal Subscriptions API integration for new subscriptions.
-   Management of PayPal API credentials (Client ID, Client Secret), Webhook ID, and Mode (Sandbox/Live) via admin settings.
-   Webhook handling for key PayPal subscription events (e.g., `BILLING.SUBSCRIPTION.ACTIVATED`, `BILLING.SUBSCRIPTION.CANCELLED`).
-   Functionality for users to cancel their active PayPal subscriptions from within the application.

## Setup & Configuration

1.  **Install Dependencies:**
    Ensure the PayPal PHP SDK is installed:
    ```bash
    composer require paypal/paypal-checkout-sdk
    ```

2.  **Database Migrations:**
    *   The `subscription_plans` table should have a `paypal_plan_id` column to store the ID of the corresponding Billing Plan created in your PayPal Developer Dashboard. If not already present, run the necessary migration.

3.  **Environment Variables (Fallback):**
    While settings are managed via the admin panel, you can have fallback values in your main `.env` file:
    ```env
    PAYPAL_MODE=sandbox
    PAYPAL_CLIENT_ID=your_sandbox_client_id
    PAYPAL_CLIENT_SECRET=your_sandbox_client_secret
    PAYPAL_WEBHOOK_ID=your_paypal_webhook_id
    ```
    Replace with your Live credentials for production after thorough testing.

4.  **Admin Configuration:**
    *   Navigate to `Admin Panel > Modules > PayPal Settings`.
    *   Select the Mode (Sandbox or Live).
    *   Enter your PayPal Client ID, Client Secret, and Webhook ID.
    *   Enable the PayPal Gateway.

5.  **PayPal Developer Dashboard Setup:**
    *   **Create REST API App:** In your PayPal Developer Dashboard, create a REST API application for both Sandbox and Live environments. Note down the Client ID and Secret for each.
    *   **Create Billing Plans:** For each subscription plan you offer in your application, you **must** create a corresponding "Billing Plan" in your PayPal Developer Dashboard (both Sandbox and Live).
        *   Configure the pricing, billing cycles, and trial periods in PayPal to match your application's plans.
        *   Note the **Plan ID** (e.g., `P-XXXXXXXXXXXXXX`) for each PayPal Billing Plan. You will need to enter this ID into the `paypal_plan_id` field when creating/editing subscription plans in your application's admin panel.
    *   **Webhook Endpoint:**
        *   In your PayPal Developer Dashboard, go to your App settings and add a Webhook.
        *   Set the "Webhook URL" to: `YOUR_APP_URL/webhooks/paypal` (e.g., `https://yourdomain.com/webhooks/paypal`). For local development, use a tunneling service like ngrok or Expose.
        *   Subscribe to relevant events. Recommended events include:
            *   `BILLING.SUBSCRIPTION.ACTIVATED`
            *   `BILLING.SUBSCRIPTION.CANCELLED`
            *   `BILLING.SUBSCRIPTION.EXPIRED`
            *   `BILLING.SUBSCRIPTION.PAYMENT.FAILED`
            *   `BILLING.SUBSCRIPTION.UPDATED`
            *   `PAYMENT.SALE.COMPLETED` (for recurring payments)
        *   Note the **Webhook ID** from PayPal and enter it in the module's admin settings in your application.

6.  **CSRF Exemption:**
    Ensure the PayPal webhook route (`webhooks/paypal`) is added to the `$except` array in `app/Http/Middleware/VerifyCsrfToken.php`.

## Usage

-   Once configured and enabled, PayPal will appear as a payment option on the subscription plans page.
-   Users can subscribe via PayPal. They will be redirected to PayPal to approve the subscription agreement.
-   Users can cancel their PayPal subscriptions from within the application (if this feature is built out in the user profile section).
-   Administrators can configure PayPal API credentials.

## Webhook Handling

The module listens for PayPal webhooks to automatically update the status of local subscription records. This includes:
-   Activating subscriptions.
-   Marking subscriptions as cancelled or expired based on PayPal events.

It is crucial that the webhook endpoint is correctly configured in PayPal, is publicly accessible, and that **webhook signature verification is fully implemented in `PaypalService.php` for production environments.** The current example service has a placeholder for this.

## Customization

-   **Views:** User-facing views related to PayPal (if any beyond redirects) can be found in `Modules/PaypalGateway/Resources/views/`.
-   **Controllers:** Logic for handling subscription creation, execution, and webhooks is in `Modules/PaypalGateway/Http/Controllers/`.
-   **Service:** Core PayPal API interactions are encapsulated in `Modules/PaypalGateway/Services/PaypalService.php`.

