<?php

namespace Modules\PaynowGateway\Providers;

use App\Models\SubscriptionPlan; // Import your SubscriptionPlan model
use Illuminate\Foundation\Support\Providers\RouteServiceProvider as ServiceProvider;
use Illuminate\Support\Facades\Route;

class RouteServiceProvider extends ServiceProvider
{
    protected string $name = 'PaynowGateway';
    protected string $moduleNamespace = 'Modules\PaynowGateway\Http\Controllers';

    /**
     * Called before routes are registered.
     *
     * Register any model bindings or pattern based filters.
     */
    public function boot(): void
    {
        parent::boot();

        // Explicitly bind the 'subscriptionPlan' route parameter if used in this module's routes
        // to resolve SubscriptionPlan models by 'slug' without global scopes.
        Route::bind('subscriptionPlan', function ($value) {
            return SubscriptionPlan::where((new SubscriptionPlan)->getRouteKeyName(), $value)
                ->withoutGlobalScopes()
                ->firstOrFail();
        });
    }

    /**
     * Define the routes for the application.
     */
    public function map(): void
    {
        $this->mapApiRoutes();
        $this->mapWebRoutes();
    }

    /**
     * Define the "web" routes for the application.
     *
     * These routes all receive session state, CSRF protection, etc.
     */
    protected function mapWebRoutes(): void
    {
        Route::middleware('web')
            ->namespace($this->moduleNamespace)
            ->group(module_path($this->name, 'routes/web.php'));
    }

    /**
     * Define the "api" routes for the application.
     *
     * These routes are typically stateless.
     */
    protected function mapApiRoutes(): void
    {
        Route::middleware('api')
            // The main app's RouteServiceProvider usually handles the 'api' middleware,
            // 'api/modulename' prefix, and 'api.modulename.' name prefix.
            // If so, ->prefix('api')->name('api.') might be redundant here.
            ->namespace($this->moduleNamespace)
            ->group(module_path($this->name, 'routes/api.php'));
    }
}
