<?php

namespace Modules\PaynowGateway\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Setting;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;

class PaynowConfigController extends Controller
{
    public function edit()
    {
        $settingKeys = [
            'paynowgateway_enabled', // Standardize key to match view/form submission
            'paynow_integration_id',
            'paynow_integration_key',
            'paynow_mode', // 'live' or 'test'/'sandbox' (check Paynow's terminology)
            'paynow_webhook_secret', // If Paynow uses webhook secrets
        ];

        $settings = [];
        foreach ($settingKeys as $key) {
            $settings[$key] = Setting::getValue($key);
        }

        if (is_null($settings['paynowgateway_enabled'])) {
            $settings['paynowgateway_enabled'] = '0'; // Use standardized key
        }
        if (is_null($settings['paynow_mode'])) {
            $settings['paynow_mode'] = 'test'; // Or Paynow's default test mode value
        }

        return view('paynowgateway::admin.config', compact('settings'));
    }

    public function update(Request $request)
    {
        $request->validate([
            'paynowgateway_enabled' => 'nullable|boolean', // Standardize key
            'paynow_integration_id' => 'nullable|string|max:255',
            'paynow_integration_key' => 'nullable|string|max:255',
            'paynow_mode' => 'required|in:test,live', // Adjust values as per Paynow
            'paynow_webhook_secret' => 'nullable|string|max:255',
        ]);

        try {
            Setting::setValue('paynowgateway_enabled', $request->input('paynowgateway_enabled', '0'), 'Enable Paynow Gateway', 'Payment Gateways', 'boolean'); // Use standardized key
            Setting::setValue('paynow_integration_id', $request->input('paynow_integration_id'), 'Paynow Integration ID', 'Payment Gateways', 'text');
            Setting::setValue('paynow_integration_key', $request->input('paynow_integration_key'), 'Paynow Integration Key', 'Payment Gateways', 'password');
            Setting::setValue('paynow_mode', $request->input('paynow_mode', 'test'), 'Paynow Mode', 'Payment Gateways', 'select');
            Setting::setValue('paynow_webhook_secret', $request->input('paynow_webhook_secret'), 'Paynow Webhook Secret', 'Payment Gateways', 'password');

            return redirect()->route('admin.paynowgateway.settings.edit')
                             ->with('success', 'Paynow settings updated successfully.');
        } catch (\Exception $e) {
            Log::error('Error updating Paynow settings: ' . $e->getMessage());
            return redirect()->route('admin.paynowgateway.settings.edit')
                             ->with('error', 'Failed to update Paynow settings. Please try again.');
        }
    }
}