@php
    // $section is available from the page renderer
    // Default values for section content
    $sectionTitle = $section->content['title'] ?? 'Latest Tenders';
    $numberOfTenders = (int)($section->content['number_of_items'] ?? 3);
    $viewAllLink = $section->content['view_all_link'] ?? null; // e.g., '/tenders'
    $viewAllText = $section->content['view_all_text'] ?? 'View All Tenders';

    // Fetch tenders from BusinessDirectory module
    try {
        $tenders = \Modules\BusinessDirectory\Entities\Tender::query()
            ->where('status', 'open') // Assuming 'open' is the status for active tenders
            ->where('deadline', '>=', now())
            ->with('company') // Eager load company
            ->orderBy('deadline', 'asc') // Show soonest to expire first, or 'created_at', 'desc' for newest
            ->take($numberOfTenders)
            ->get();
    } catch (\Throwable $e) {
        $tenders = collect();
        \Illuminate\Support\Facades\Log::error("Error fetching tenders for landing page section: " . $e->getMessage());
    }
@endphp

@if($tenders->isNotEmpty())
<section class="py-12 md:py-20 bg-white dark:bg-gray-800">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        <h2 class="text-3xl font-bold text-center text-gray-800 dark:text-white mb-10">{{ $sectionTitle }}</h2>
        <div class="space-y-8">
            @foreach($tenders as $tender)
                <div class="bg-gray-50 dark:bg-gray-700 p-6 rounded-lg shadow-md hover:shadow-lg transition-shadow duration-300">
                    <div class="md:flex md:justify-between md:items-start">
                        <div class="flex-grow">
                            <h3 class="text-xl font-semibold text-[var(--clr-accent)] mb-1">{{ $tender->title }}</h3>
                            @if($tender->company)
                            <p class="text-sm text-gray-500 dark:text-gray-400 mb-1">Posted by: {{ $tender->company->name }}</p>
                            @endif
                            <p class="text-sm text-gray-500 dark:text-gray-400 mb-2">Location: {{ $tender->location ?? 'N/A' }}</p>
                            <p class="text-gray-600 dark:text-gray-300 text-sm mb-3">{{ Str::limit($tender->description ?? 'No description available.', 150) }}</p>
                        </div>
                        <div class="mt-4 md:mt-0 md:ml-6 md:text-right flex-shrink-0">
                            <p class="text-sm text-gray-700 dark:text-gray-200 font-semibold">Budget: {{ $tender->currency }} {{ number_format($tender->budget_min,0) }} - {{ number_format($tender->budget_max,0) }}</p>
                            <p class="text-sm text-red-500 dark:text-red-400">Deadline: {{ $tender->deadline ? $tender->deadline->format('M d, Y') : 'N/A' }}</p>
                            <a href="{{-- route('module.tenders.show', $tender->slug) --}}#" class="mt-3 inline-block text-purple-500 hover:text-purple-700 dark:hover:text-purple-300 font-medium text-sm">View Tender &rarr;</a>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
        @if($viewAllLink)
        <div class="text-center mt-12">
            <a href="{{ url($viewAllLink) }}" class="inline-block bg-purple-600 hover:bg-purple-700 text-white font-semibold py-3 px-8 rounded-lg transition duration-300">
                {{ $viewAllText }}
            </a>
        </div>
        @endif
    </div>
</section>
@endif