@php
    // $section is available from the page renderer
    // Default values for section content
    $sectionTitle = $section->content['title'] ?? 'Recent Company Projects';
    $numberOfProjects = (int)($section->content['number_of_items'] ?? 3);
    // Example: Allow filtering by status, e.g., 'completed', 'in_progress'
    $projectStatus = $section->content['project_status'] ?? 'completed';
    $viewAllLink = $section->content['view_all_link'] ?? null; // e.g., '/company-projects'
    $viewAllText = $section->content['view_all_text'] ?? 'View All Projects';

    // Fetch company projects from BusinessDirectory module
    try {
        $projectsQuery = \Modules\BusinessDirectory\Entities\CompanyProject::query()
            ->with('company'); // Eager load the company

        if (!empty($projectStatus) && $projectStatus !== 'all') {
            $projectsQuery->where('status', $projectStatus);
        }

        $projects = $projectsQuery
            ->orderBy('end_date', 'desc') // Show recently completed/updated first
            ->take($numberOfProjects)
            ->get();
    } catch (\Throwable $e) {
        $projects = collect();
        \Illuminate\Support\Facades\Log::error("Error fetching company projects for landing page section: " . $e->getMessage());
    }
@endphp

@if($projects->isNotEmpty())
<section class="py-12 md:py-20 bg-white dark:bg-gray-800">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        <h2 class="text-3xl font-bold text-center text-gray-800 dark:text-white mb-10">{{ $sectionTitle }}</h2>
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            @foreach($projects as $project)
                <div class="bg-gray-50 dark:bg-gray-700 p-6 rounded-lg shadow-md hover:shadow-lg transition-shadow duration-300">
                    <h3 class="text-xl font-semibold text-[var(--clr-accent)] mb-2">{{ $project->name }}</h3>
                    @if($project->company)
                    <p class="text-sm text-gray-500 dark:text-gray-400 mb-1">By: {{ $project->company->name }}</p>
                    @endif
                    <p class="text-sm text-gray-500 dark:text-gray-400 mb-3">Status: <span class="font-medium">{{ Str::title(str_replace('_', ' ', $project->status)) }}</span></p>
                    <p class="text-gray-600 dark:text-gray-300 text-sm mb-3">{{ Str::limit($project->description ?? 'Project description unavailable.', 120) }}</p>
                    <a href="{{-- route('module.company-projects.show', $project->slug) --}}#" class="text-purple-500 hover:text-purple-700 dark:hover:text-purple-300 font-medium text-sm">View Project Details &rarr;</a>
                </div>
            @endforeach
        </div>
        @if($viewAllLink)
        <div class="text-center mt-12">
            <a href="{{ url($viewAllLink) }}" class="inline-block bg-purple-600 hover:bg-purple-700 text-white font-semibold py-3 px-8 rounded-lg transition duration-300">
                {{ $viewAllText }}
            </a>
        </div>
        @endif
    </div>
</section>
@endif