<footer class="bg-gray-100 dark:bg-gray-900 text-gray-600 dark:text-gray-300 py-12">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            {{-- Column 1: About Company --}}
            <div>
                <div class="mb-4">
                    <a href="{{ url('/') }}" class="text-xl font-bold text-gray-800 dark:text-gray-200">
                        @if(setting('site_logo') && \Illuminate\Support\Facades\Storage::disk('public')->exists(str_replace(\Illuminate\Support\Facades\Storage::url(''), '', setting('site_logo'))))
                            <img src="{{ \Illuminate\Support\Facades\Storage::url(setting('site_logo')) }}" alt="{{ setting('site_name', 'Digital Vocano') }}" class="h-8 w-auto">
                        @else
                            {{ setting('site_name', 'Digital Vocano') }}
                        @endif
                    </a>
                </div>
                <p class="text-sm">{{ setting('site_description', 'Crafting innovative digital solutions that drive success.') }}</p>
                
                {{-- Social Icons in Footer --}}
                <div class="flex mt-4 space-x-4">
                    @php
                        $socialLinks = [
                            'social_facebook_url' => ['icon' => 'fab fa-facebook-f', 'label' => 'Facebook', 'color' => 'hover:text-blue-600 dark:hover:text-blue-500'],
                            'social_twitter_url' => ['icon' => 'fab fa-twitter', 'label' => 'Twitter / X', 'color' => 'hover:text-sky-500 dark:hover:text-sky-400'], // or fa-brands fa-x-twitter
                            'social_linkedin_url' => ['icon' => 'fab fa-linkedin-in', 'label' => 'LinkedIn', 'color' => 'hover:text-blue-700 dark:hover:text-blue-600'],
                            'social_instagram_url' => ['icon' => 'fab fa-instagram', 'label' => 'Instagram', 'color' => 'hover:text-pink-500 dark:hover:text-pink-400'],
                            'social_youtube_url' => ['icon' => 'fab fa-youtube', 'label' => 'YouTube', 'color' => 'hover:text-red-600 dark:hover:text-red-500'],
                            'social_tiktok_url' => ['icon' => 'fab fa-tiktok', 'label' => 'TikTok', 'color' => 'hover:text-black dark:hover:text-white'],
                        ];
                    @endphp

                    @foreach($socialLinks as $key => $details)
                        @if(setting($key))
                            <a href="{{ setting($key) }}" target="_blank" rel="noopener noreferrer" 
                               class="text-gray-400 dark:text-gray-500 {{ $details['color'] }} transition-colors duration-300" 
                               aria-label="{{ $details['label'] }}" title="{{ $details['label'] }}">
                                <i class="{{ $details['icon'] }} fa-lg"></i>
                            </a>
                        @endif 
                    @endforeach {{-- Corrected: This should be @endforeach to close the loop started on line 22 --}}
                </div>
            </div>

            {{-- Column 2: Quick Links --}}
            <div>
                <h4 class="text-sm font-semibold text-gray-700 dark:text-gray-200 mb-4">Quick Links</h4>
                <ul class="space-y-2 text-sm">
                    <li>
                        <a href="{{ route('landingpage.page.show') }}" class="hover:text-purple-500 dark:hover:text-purple-400">
                            Home
                        </a>
                    </li>
                    @foreach(\Modules\LandingPage\Entities\LpPage::whereIn('slug', ['about-us', 'services', 'projects'])->where('is_published', true)->get() as $page)
                        <li>
                            <a href="{{ route('landingpage.page.show', $page->slug) }}" class="hover:text-purple-500 dark:hover:text-purple-400">
                                {{ $page->title }}
                            </a>
                        </li>
                    @endforeach
                </ul>
            </div>

             {{-- Column 3: Contact & Legal --}}
            <div>
                <h4 class="text-sm font-semibold text-gray-700 dark:text-gray-200 mb-4">Contact & Legal</h4>
                <ul class="space-y-2 text-sm">
                    @foreach(\Modules\LandingPage\Entities\LpPage::whereIn('slug', ['contact', 'privacy-policy', 'terms-of-service'])->where('is_published', true)->get() as $page)
                        <li>
                            <a href="{{ route('landingpage.page.show', $page->slug) }}" class="hover:text-purple-500 dark:hover:text-purple-400">
                                {{ $page->title }}
                            </a>
                        </li>
                    @endforeach
                </ul>
            </div>
        </div>

        <div class="mt-12 py-4 border-t border-gray-200 dark:border-gray-700 text-center text-sm text-gray-500 dark:text-gray-400">
            <p>&copy; {{ date('Y') }} {{ setting('site_name', 'Digital Vocano') }}. All rights reserved.</p>
        </div>
    </div>
</footer>
