@extends('landingpage::themes.job_board.layouts.master')

@php
    // $tenders is paginated collection from PublicPageController
    // $pageTitle, $metaDescription, $activeTheme are also available

    $page = (object) [
        'title' => $pageTitle ?? 'Current Tenders',
        'meta_title' => $pageTitle ?? 'Current Tenders - ' . setting('site_name'),
        'meta_description' => $metaDescription ?? 'Browse current tender opportunities.',
        'meta_keywords' => 'tenders, procurement, bids, contracts, opportunities',
        'slug' => 'tenders'
    ];
@endphp

@section('theme_content')
<div class="bg-slate-50 dark:bg-slate-900 py-12 md:py-16">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        <header class="mb-10 text-center">
            <h1 class="text-4xl font-bold tracking-tight text-slate-900 dark:text-slate-100 sm:text-5xl">
                {{ $page->title }}
            </h1>
            @if($page->meta_description)
            <p class="mt-3 text-lg leading-8 text-slate-600 dark:text-slate-300">
                {{ $page->meta_description }}
            </p>
            @endif
        </header>

        {{-- Search/Filter Bar for Tenders --}}
        <div class="mb-10 bg-white dark:bg-slate-800 p-6 rounded-lg shadow-md">
            <form action="{{ route('landingpage.tenders.index') }}" method="GET" class="grid grid-cols-1 md:grid-cols-3 gap-4 items-end">
                <div>
                    <label for="keywords" class="block text-sm font-medium text-slate-700 dark:text-slate-300">Tender Title/Keyword</label>
                    <input type="text" name="keywords" id="keywords" value="{{ request('keywords') }}" placeholder="e.g., Construction, IT Services" class="mt-1 block w-full rounded-md border-slate-300 dark:border-slate-600 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm dark:bg-slate-700 dark:text-slate-200">
                </div>
                <div>
                    <label for="location" class="block text-sm font-medium text-slate-700 dark:text-slate-300">Location</label>
                    <input type="text" name="location" id="location" value="{{ request('location') }}" placeholder="e.g., City, Country" class="mt-1 block w-full rounded-md border-slate-300 dark:border-slate-600 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm dark:bg-slate-700 dark:text-slate-200">
                </div>
                <button type="submit" class="w-full md:w-auto bg-blue-600 hover:bg-blue-700 text-white font-semibold py-2.5 px-4 rounded-md text-sm shadow-sm transition duration-150">Search Tenders</button>
            </form>
        </div>

        @if($tenders->isNotEmpty())
            <div class="space-y-6">
                @foreach($tenders as $tender)
                    <div class="bg-white dark:bg-slate-800 rounded-lg shadow-lg hover:shadow-xl transition-shadow duration-300 ease-in-out">
                        <div class="p-6">
                            <div class="flex flex-col sm:flex-row justify-between sm:items-center mb-2">
                                <h2 class="text-xl font-semibold text-slate-900 dark:text-slate-100">
                                    <a href="{{ route('theme.tender.show', $tender->slug) }}" class="hover:text-blue-600 dark:hover:text-blue-400 transition-colors">
                                        {{ $tender->title }}
                                    </a>
                                </h2>
                                @if($tender->deadline)
                                <p class="text-sm text-red-600 dark:text-red-400 mt-1 sm:mt-0">
                                    <i class="fas fa-calendar-times mr-1"></i>Deadline: {{ $tender->deadline->format('M d, Y') }}
                                    ({{ $tender->deadline->diffForHumans() }})
                                </p>
                                @endif
                            </div>
                            @if($tender->company)
                                <p class="text-sm text-slate-600 dark:text-slate-400 mb-3">
                                    Posted by: <a href="{{ route('theme.company.show', $tender->company->slug) }}" class="hover:underline">{{ $tender->company->name }}</a>
                                </p>
                            @endif
                            <p class="text-sm text-slate-500 dark:text-slate-400 mb-1"><i class="fas fa-map-marker-alt mr-2 text-slate-400"></i>{{ $tender->location ?: 'Not specified' }}</p>
                            <p class="text-sm text-slate-500 dark:text-slate-400 mb-4"><i class="fas fa-tag mr-2 text-slate-400"></i>Type: {{ $tender->type ? Str::title($tender->type) : 'Not specified' }}</p>
                            <a href="{{ route('theme.tender.show', $tender->slug) }}" class="inline-block text-sm font-medium text-blue-600 dark:text-blue-400 hover:text-blue-700 dark:hover:text-blue-300">
                                View Tender <i class="fas fa-arrow-right ml-1"></i>
                            </a>
                        </div>
                    </div>
                @endforeach
            </div>

            <div class="mt-12">
                {{ $tenders->links('landingpage::themes.job_board.partials.pagination') }}
            </div>
        @else
            <p class="text-center text-slate-500 dark:text-slate-400 text-lg">No tenders found at the moment. Please check back later.</p>
        @endif
    </div>
</div>
@endsection