@extends('landingpage::themes.job_board.layouts.master')

{{-- $page is constructed in FrontendController for meta tags --}}
{{-- $tender is the actual tender model instance --}}

@section('theme_content')
<div class="container mx-auto px-4 sm:px-6 lg:px-8 py-12">
    <article class="bg-white dark:bg-slate-800 shadow-xl rounded-lg p-6 md:p-8">
        <header class="mb-8">
            <h1 class="text-3xl md:text-4xl font-bold text-slate-900 dark:text-slate-100 mb-2">{{ $tender->title }}</h1>
            @if($tender->company)
                <p class="text-lg text-slate-700 dark:text-slate-300 mb-1">
                    Posted by: <a href="{{ route('theme.company.show', $tender->company->slug) }}" class="hover:text-blue-600 dark:hover:text-blue-400">{{ $tender->company->name }}</a>
                </p>
            @endif
            <div class="text-sm text-slate-500 dark:text-slate-400 space-x-4">
                @if($tender->location)
                    <span><i class="fas fa-map-marker-alt mr-1"></i>{{ $tender->location }}</span>
                @endif
                @if($tender->type)
                    <span><i class="fas fa-file-contract mr-1"></i>Type: {{ Str::title($tender->type) }}</span>
                @endif
                @if($tender->deadline)
                    <span><i class="fas fa-calendar-times mr-1"></i>Deadline: {{ $tender->deadline->format('M d, Y H:i A') }}</span>
                @endif
            </div>
        </header>

        @if($tender->budget_min || $tender->budget_max)
        <div class="mb-6 p-4 bg-slate-50 dark:bg-slate-700 rounded-md">
            <h3 class="text-md font-semibold text-slate-700 dark:text-slate-200">Budget</h3>
            <p class="text-lg text-slate-800 dark:text-slate-100">
                @if($tender->budget_min && $tender->budget_max)
                    {{ $tender->currency ?? '$' }}{{ number_format($tender->budget_min, 2) }} - {{ $tender->currency ?? '$' }}{{ number_format($tender->budget_max, 2) }}
                @elseif($tender->budget_min)
                    Starts from {{ $tender->currency ?? '$' }}{{ number_format($tender->budget_min, 2) }}
                @elseif($tender->budget_max)
                    Up to {{ $tender->currency ?? '$' }}{{ number_format($tender->budget_max, 2) }}
                @endif
            </p>
        </div>
        @endif

        <div class="prose dark:prose-invert max-w-none mb-8">
            {!! $tender->description !!} {{-- Sanitize if user-generated --}}
        </div>

        <div class="border-t border-slate-200 dark:border-slate-700 pt-6">
            <h3 class="text-xl font-semibold text-slate-800 dark:text-slate-200 mb-4">Submit a Bid / Proposal</h3>
            {{-- Placeholder for bid submission form or instructions --}}
            <p class="text-slate-600 dark:text-slate-400">Information on how to submit a bid will appear here.</p>
            <a href="#" {{-- Link to bid submission page or mailto --}}
               class="mt-4 inline-block bg-green-600 hover:bg-green-700 text-white font-semibold py-3 px-6 rounded-lg text-md shadow-md hover:shadow-lg transition-all duration-300">
                Submit Proposal <i class="fas fa-paper-plane ml-2"></i>
            </a>
        </div>
    </article>
</div>
@endsection