@extends('landingpage::themes.job_board.layouts.master')

{{-- $page is constructed in FrontendController for meta tags --}}
{{-- $product is the actual product model instance --}}

@section('theme_content')
<div class="container mx-auto px-4 sm:px-6 lg:px-8 py-12">
    <article class="bg-white dark:bg-slate-800 shadow-xl rounded-lg p-6 md:p-8">
        <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
            {{-- Product Images --}}
            <div>
                @if($product->images && !empty($product->images[0]))
                    {{-- Main Image --}}
                    <img src="{{ asset('storage/' . $product->images[0]) }}" alt="{{ $product->name }}" class="w-full h-auto object-cover rounded-lg shadow-md mb-4">
                    {{-- Thumbnails (if more than one image) --}}
                    @if(count($product->images) > 1)
                        <div class="grid grid-cols-4 gap-2">
                            @foreach($product->images as $image)
                                <img src="{{ asset('storage/' . $image) }}" alt="{{ $product->name }} thumbnail" class="w-full h-20 object-cover rounded-md cursor-pointer border-2 border-transparent hover:border-blue-500">
                            @endforeach
                        </div>
                    @endif
                @else
                    <div class="w-full h-64 bg-slate-200 dark:bg-slate-700 rounded-lg flex items-center justify-center text-slate-500">
                        <i class="fas fa-image fa-3x"></i>
                    </div>
                @endif
            </div>

            {{-- Product Details --}}
            <div>
                <h1 class="text-3xl md:text-4xl font-bold text-slate-900 dark:text-slate-100 mb-2">{{ $product->name }}</h1>
                @if($product->company)
                    <p class="text-md text-slate-600 dark:text-slate-400 mb-4">Sold by: <a href="{{ route('theme.company.show', $product->company->slug) }}" class="text-blue-600 hover:underline">{{ $product->company->name }}</a></p>
                @endif

                <div class="mb-4">
                    @if($product->sale_price && $product->sale_price < $product->price)
                        <span class="text-3xl font-bold text-red-600 dark:text-red-400 mr-2">${{ number_format($product->sale_price, 2) }}</span>
                        <span class="text-xl text-slate-500 dark:text-slate-400 line-through">${{ number_format($product->price, 2) }}</span>
                    @else
                        <span class="text-3xl font-bold text-slate-800 dark:text-slate-200">${{ number_format($product->price, 2) }}</span>
                    @endif
                </div>

                @if($product->sku)
                    <p class="text-sm text-slate-500 dark:text-slate-400 mb-4">SKU: {{ $product->sku }}</p>
                @endif

                <div class="prose dark:prose-invert max-w-none mb-6">
                    {!! $product->description !!} {{-- Sanitize if user-generated --}}
                </div>

                {{-- Add to Cart Button / Stock Status --}}
                <button class="w-full bg-blue-600 hover:bg-blue-700 text-white font-semibold py-3 px-6 rounded-lg text-md shadow-md hover:shadow-lg transition-all duration-300">
                    Add to Cart <i class="fas fa-shopping-cart ml-2"></i>
                </button>
                @if($product->stock_quantity !== null)
                    <p class="text-sm text-slate-600 dark:text-slate-400 mt-3">{{ $product->stock_quantity > 0 ? $product->stock_quantity . ' in stock' : 'Out of stock' }}</p>
                @endif
            </div>
        </div>
    </article>
</div>
@endsection