@extends('landingpage::themes.job_board.layouts.master')

{{--
    $page is the LpPage object representing the news article (or a dedicated Article model instance in the future)
    $article is an alias for $page if using LpPage, or the dedicated Article model.
--}}

@section('theme_content')
<div class="container mx-auto px-4 sm:px-6 lg:px-8 py-12">
    <article class="bg-white dark:bg-slate-800 shadow-xl rounded-lg p-6 md:p-8">
        <header class="mb-8">
            <h1 class="text-3xl md:text-4xl font-bold text-slate-900 dark:text-slate-100 mb-2">{{ $article->title }}</h1>
            <div class="text-sm text-slate-500 dark:text-slate-400">
                @if($article->created_at) {{-- Or a specific published_at date --}}
                    <span><i class="fas fa-calendar-alt mr-1"></i>Published: {{ $article->created_at->format('M d, Y') }}</span>
                @endif
                {{-- Add author, category if available --}}
            </div>
        </header>

        <div class="prose dark:prose-invert max-w-none">
            {!! $article->content !!} {{-- This assumes news content is stored in LpPage's content field --}}
        </div>
    </article>
</div>
@endsection