@extends('landingpage::themes.job_board.layouts.app')

{{-- $page is constructed in FrontendController for meta tags --}}
{{-- $company is the company model instance --}}
{{-- $tenders is the paginated collection of tenders --}}

@section('content')
<div class="container mx-auto px-4 py-8">
    <div class="mb-6">
        <a href="{{ route('theme.company.show', $company->slug) }}" class="text-indigo-600 dark:text-indigo-400 hover:underline">&larr; Back to {{ $company->name }}'s Profile</a>
    </div>

    <h1 class="text-3xl font-bold text-gray-800 dark:text-gray-100 mb-6">Tenders from {{ $company->name }}</h1>

    @if($tenders->isEmpty())
        <div class="bg-white dark:bg-slate-800 shadow-md rounded-lg p-6 text-center">
            <p class="text-gray-600 dark:text-gray-400 text-lg">This company currently has no tenders listed.</p>
        </div>
    @else
        <div class="space-y-6">
            @foreach($tenders as $tender)
                <div class="bg-white dark:bg-slate-800 p-6 rounded-lg shadow-md hover:shadow-lg transition-shadow duration-300">
                    <h2 class="text-xl font-semibold text-gray-800 dark:text-gray-100">
                        <a href="{{ route('theme.tender.show', $tender->slug) }}" class="hover:text-indigo-600 dark:hover:text-indigo-400">{{ $tender->title }}</a>
                    </h2>
                    <p class="text-sm text-gray-500 dark:text-gray-400">
                        {{ $tender->location ?: 'Not specified' }}
                    </p>
                    @if($tender->deadline)
                    <p class="text-xs text-gray-400 dark:text-gray-500 mt-1">Deadline: {{ $tender->deadline->format('M d, Y H:i A') }}</p>
                    @endif
                </div>
            @endforeach
        </div>
        <div class="mt-8">
            {{ $tenders->links() }}
        </div>
    @endif
</div>
@endsection