{{--
    Standalone Search Form Section
    Expects $content to have keys like:
    $content['section_title'] (optional)
    $content['search_placeholder_keywords']
    $content['search_placeholder_location']
    $content['search_target_url'] (e.g., /jobs)
    $content['button_text']
--}}
@php
    $sectionTitle = $content['section_title'] ?? null;
    $keywordsPlaceholder = $content['search_placeholder_keywords'] ?? 'Keywords (e.g., Developer)';
    $locationPlaceholder = $content['search_placeholder_location'] ?? 'Location (e.g., City, State)';
    $targetUrl = $content['search_target_url'] ?? url('/jobs');
    $buttonText = $content['button_text'] ?? 'Search';
@endphp

<section class="py-12 md:py-16 bg-slate-100 dark:bg-slate-800">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        @if($sectionTitle)
            <h2 class="text-2xl md:text-3xl font-semibold text-slate-800 dark:text-slate-100 text-center mb-8">{{ $sectionTitle }}</h2>
        @endif

        <form action="{{ $targetUrl }}" method="GET" class="max-w-xl mx-auto bg-white dark:bg-slate-700 p-6 rounded-lg shadow-lg grid grid-cols-1 sm:grid-cols-3 gap-4 items-end">
            <input type="text" name="keywords" placeholder="{{ $keywordsPlaceholder }}"
                   class="sm:col-span-1 p-3 border border-slate-300 dark:border-slate-600 rounded-md focus:ring-blue-500 focus:border-blue-500 text-slate-700 dark:text-slate-200 dark:bg-slate-600">
            <input type="text" name="location" placeholder="{{ $locationPlaceholder }}"
                   class="sm:col-span-1 p-3 border border-slate-300 dark:border-slate-600 rounded-md focus:ring-blue-500 focus:border-blue-500 text-slate-700 dark:text-slate-200 dark:bg-slate-600">
            <button type="submit"
                    class="sm:col-span-1 w-full bg-blue-600 hover:bg-blue-700 text-white font-semibold p-3 rounded-md transition duration-150">
                {{ $buttonText }}
            </button>
        </form>
    </div>
</section>