{{--
    News Grid Layout
    Expects $content to have keys like:
    $content['section_title'] (optional)
    $content['number_of_articles'] (e.g., 3, 6)
    $content['view_all_link'] (optional, e.g., /news)
    $content['view_all_text'] (optional, e.g., Read More News)
--}}
@php
    $sectionTitle = $content['section_title'] ?? 'Latest News & Articles';
    $numberOfArticles = (int)($content['number_of_articles'] ?? 3);
    $viewAllLink = $content['view_all_link'] ?? null;
    $viewAllText = $content['view_all_text'] ?? 'View All News';

    // Fetch news articles. For now, assuming LpPage with a specific template or category.
    // Replace this with your actual News/Article model fetching logic.
    $articles = \Modules\LandingPage\Entities\LpPage::where('is_published', true)
                                                // ->where('theme_template', 'news_article_template') // Example filter
                                                ->orderBy('created_at', 'desc')
                                                ->take($numberOfArticles)
                                                ->get();
@endphp

<section class="py-12 md:py-16 bg-white dark:bg-slate-900">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        @if($sectionTitle)
            <h2 class="text-3xl font-bold text-slate-800 dark:text-slate-100 text-center mb-10">{{ $sectionTitle }}</h2>
        @endif

        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            @forelse($articles as $article)
                <div class="bg-slate-50 dark:bg-slate-800 rounded-lg shadow-lg overflow-hidden hover:shadow-xl transition-shadow duration-300">
                    {{-- Add article image if available --}}
                    <div class="p-6">
                        <h3 class="text-xl font-semibold text-slate-900 dark:text-slate-100 mb-2"><a href="{{ route('theme.news.show', $article->slug) }}" class="hover:text-blue-600 dark:hover:text-blue-400">{{ $article->title }}</a></h3>
                        <p class="text-sm text-slate-500 dark:text-slate-400 mb-3">{{ $article->created_at->format('M d, Y') }}</p>
                        <p class="text-slate-600 dark:text-slate-300 text-sm mb-4">{{ Str::limit(strip_tags($article->content), 120) }}</p>
                        <a href="{{ route('theme.news.show', $article->slug) }}" class="font-medium text-blue-600 dark:text-blue-400 hover:underline">Read More &rarr;</a>
                    </div>
                </div>
            @empty
                <p class="col-span-full text-center text-slate-500 dark:text-slate-400">No news articles found.</p>
            @endforelse
        </div>

        @if($viewAllLink && $articles->isNotEmpty())
            <div class="text-center mt-12">
                <a href="{{ url($viewAllLink) }}"
                   class="inline-block bg-blue-600 hover:bg-blue-700 text-white font-semibold py-3 px-8 rounded-lg text-md shadow-md hover:shadow-lg transition-all duration-300">
                    {{ $viewAllText }}
                </a>
            </div>
        @endif
    </div>
</section>