{{--
    Hero Section with Background Image
    Expects $section and $content.
    Content fields:
    - background_image_url (required)
    - background_image_alt (optional, defaults to section title)
    - overlay_color (optional, e.g., 'bg-black')
    - overlay_opacity (optional, e.g., 'opacity-50')
    - title (required)
    - title_tag (optional, defaults to 'h1')
    - title_color (optional, defaults to 'text-white')
    - subtitle (optional)
    - subtitle_color (optional, defaults to 'text-gray-200')
    - content_align (optional, 'text-center', 'text-start', 'text-end', defaults to 'text-center')
    - button_text (optional)
    - button_link (optional)
    - button_class (optional, e.g., 'bg-yellow-400 hover:bg-yellow-500 text-gray-900')
    - secondary_button_text (optional)
    - secondary_button_link (optional)
    - secondary_button_class (optional, e.g., 'border-2 border-gray-300 hover:bg-gray-100 hover:text-purple-700 text-white')
    - min_height (optional, e.g., 'min-h-[70vh]', defaults to 'min-h-[60vh] md:min-h-[75vh]')
--}}
@php
    $titleTag = $content['title_tag'] ?? 'h1';
    $titleColor = $content['title_color'] ?? 'text-white';
    $subtitleColor = $content['subtitle_color'] ?? 'text-gray-200 dark:text-gray-300';
    $contentAlign = $content['content_align'] ?? 'text-center';
    $minHeight = $content['min_height'] ?? 'min-h-[60vh] md:min-h-[75vh]';
@endphp

<section id="section-{{ $section->id }}" class="relative {{ $minHeight }} flex items-center justify-center overflow-hidden {{ $content['text_color'] ?? 'text-white' }}">
    @if(!empty($content['background_image_url']))
        <img src="{{ $content['background_image_url'] }}" alt="{{ $content['background_image_alt'] ?? $section->title ?? 'Hero background' }}" class="absolute inset-0 w-full h-full object-cover">
    @endif
    <div class="absolute inset-0 {{ $content['overlay_color'] ?? 'bg-black' }} {{ $content['overlay_opacity'] ?? 'opacity-40' }}"></div>

    <div class="container mx-auto px-4 sm:px-6 lg:px-8 py-20 md:py-28 relative z-10 {{ $contentAlign }}">
        <{{ $titleTag }} class="text-4xl sm:text-5xl md:text-6xl font-extrabold mb-6 leading-tight {{ $titleColor }}">{{ $content['title'] }}</{{ $titleTag }}>

        @if(!empty($content['subtitle']))
            <p class="text-lg md:text-xl lg:text-2xl mb-10 max-w-3xl {{ $contentAlign === 'text-center' ? 'mx-auto' : ($contentAlign === 'text-end' ? 'ms-auto' : 'me-auto') }} {{ $subtitleColor }}">{{ $content['subtitle'] }}</p>
        @endif

        <div class="space-y-4 sm:space-y-0 {{ $contentAlign === 'text-center' ? 'sm:flex sm:justify-center sm:space-x-4' : 'space-x-0 sm:space-x-4' }}">
            @if(!empty($content['button_text']) && !empty($content['button_link']))
                <a href="{{ $content['button_link'] }}" class="inline-block {{ $content['button_class'] ?? 'bg-purple-600 hover:bg-purple-700 text-white' }} font-bold py-3 px-10 rounded-lg text-lg shadow-xl transform hover:scale-105 transition-all duration-300 ease-in-out">
                    {{ $content['button_text'] }}
                </a>
            @endif
            @if(!empty($content['secondary_button_text']) && !empty($content['secondary_button_link']))
                <a href="{{ $content['secondary_button_link'] }}" class="inline-block {{ $content['secondary_button_class'] ?? 'border-2 border-gray-300 hover:bg-gray-100 hover:text-purple-700 text-white' }} font-bold py-3 px-10 rounded-lg text-lg shadow-xl transform hover:scale-105 transition-all duration-300 ease-in-out">
                    {{ $content['secondary_button_text'] }}
                </a>
            @endif
        </div>
    </div>
</section>