{{--
    Callout Box Layout
    Expects $section and $content.
    Content fields:
    - title (required)
    - title_tag (optional, defaults to 'h3')
    - text_content (required)
    - image_url (optional, for a small icon or image)
    - image_alt (optional)
    - image_position (optional, 'left', 'right', 'top', defaults to 'left')
    - button_text (optional)
    - button_link (optional)
    - button_class (optional)
    - box_bg_color (optional, defaults to 'bg-purple-50 dark:bg-purple-900/30')
    - box_border_color (optional, defaults to 'border-purple-500 dark:border-purple-700')
    - box_text_color (optional, defaults to 'text-purple-800 dark:text-purple-200')
--}}
@php
    $titleTag = $content['title_tag'] ?? 'h3';
    $boxBgColor = $content['box_bg_color'] ?? 'bg-purple-50 dark:bg-purple-900/50';
    $boxBorderColor = $content['box_border_color'] ?? 'border-purple-500 dark:border-purple-700';
    $boxTextColor = $content['box_text_color'] ?? 'text-purple-800 dark:text-purple-200';
    $imagePosition = $content['image_position'] ?? 'left'; // 'left', 'right', 'top'
@endphp

<section id="section-{{ $section->id }}" class="py-12 md:py-16 {{ $content['section_bg_color'] ?? 'bg-transparent' }}">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        <div class="{{ $boxBgColor }} {{ $boxTextColor }} border-s-4 {{ $boxBorderColor }} p-6 md:p-8 rounded-lg shadow-lg flex {{ $imagePosition === 'top' ? 'flex-col items-center text-center' : 'items-start' }} gap-6">
            @if(!empty($content['image_url']) && ($imagePosition === 'left' || $imagePosition === 'top'))
                <img src="{{ $content['image_url'] }}" alt="{{ $content['image_alt'] ?? '' }}" class="w-16 h-16 {{ $imagePosition === 'top' ? 'mb-4' : 'me-4' }} flex-shrink-0 object-contain">
            @endif
            <div class="flex-grow">
                <{{ $titleTag }} class="text-2xl font-semibold mb-3">{{ $content['title'] }}</{{ $titleTag }}>
                <div class="prose dark:prose-invert max-w-none {{ $boxTextColor }}">{!! $content['text_content'] !!}</div>
                @if(!empty($content['button_text']) && !empty($content['button_link']))
                    <div class="mt-6">
                        <a href="{{ $content['button_link'] }}" class="inline-block {{ $content['button_class'] ?? 'bg-purple-600 hover:bg-purple-700 text-white' }} font-semibold py-2 px-6 rounded-md text-sm shadow-md hover:shadow-lg transition-all duration-300">
                            {{ $content['button_text'] }}
                        </a>
                    </div>
                @endif
            </div>
            @if(!empty($content['image_url']) && $imagePosition === 'right')
                <img src="{{ $content['image_url'] }}" alt="{{ $content['image_alt'] ?? '' }}" class="w-16 h-16 ms-4 flex-shrink-0 object-contain">
            @endif
        </div>
    </div>
</section>