{{--
    Expects:
    - $content: array of section settings (e.g., title, subtitle, bg_color, text_color, items_to_show, view_all_link)
    - $featured_products_data: Collection of featured product models.
--}}
@php
    $sectionTitle = $content['title'] ?? 'Featured Products';
    $bgColor = $content['bg_color'] ?? 'bg-white dark:bg-slate-900';
    $textColor = $content['text_color'] ?? 'text-gray-800 dark:text-gray-100';
    $itemsToShow = (int) ($content['items_to_show'] ?? 4);
    $viewAllLink = $content['view_all_link'] ?? route('landingpage.products.index');
    $products = $featured_products_data ?? collect();
@endphp

<section class="py-12 md:py-16 {{ $bgColor }}">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        <h2 class="text-3xl font-bold text-center mb-2 {{ $textColor }}">{{ $sectionTitle }}</h2>
        @if(!empty($content['subtitle']))
            <p class="text-lg text-center text-gray-600 dark:text-gray-400 mb-10 max-w-2xl mx-auto">{{ $content['subtitle'] }}</p>
        @else
            <div class="mb-10"></div>
        @endif

        @if($products->isNotEmpty())
            <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-6">
                @foreach($products->take($itemsToShow) as $product)
                    <div class="bg-white dark:bg-slate-800 rounded-lg shadow-lg overflow-hidden hover:shadow-xl transition-shadow duration-300">
                        <a href="{{ route('theme.product.show', $product->slug) }}" class="block">
                            @if($product->images && !empty($product->images[0]))
                                <img src="{{ Storage::url($product->images[0]) }}" alt="{{ $product->name }}" class="w-full h-56 object-cover">
                            @else
                                <div class="w-full h-56 bg-slate-200 dark:bg-slate-700 flex items-center justify-center text-slate-400 dark:text-slate-500">
                                    <i class="fas fa-image fa-3x"></i>
                                </div>
                            @endif
                            <div class="p-4">
                                <h4 class="font-semibold text-md {{ $textColor }} hover:text-purple-600 dark:hover:text-purple-400 truncate" title="{{ $product->name }}">{{ $product->name }}</h4>
                                <p class="text-sm text-purple-600 dark:text-purple-400 font-bold mt-1">${{ number_format($product->price, 2) }}</p>
                                {{-- You can add sale price logic here if needed --}}
                            </div>
                        </a>
                    </div>
                @endforeach
            </div>
            @if($viewAllLink && $products->count() > $itemsToShow)
                <div class="text-center mt-10">
                    <a href="{{ $viewAllLink }}" class="inline-block bg-purple-600 hover:bg-purple-700 text-white font-semibold py-3 px-8 rounded-lg text-md shadow-md hover:shadow-lg transition-all duration-300">View All Products</a>
                </div>
            @endif
        @else
            <p class="text-center text-gray-500 dark:text-gray-400">No featured products to display at the moment.</p>
        @endif
    </div>
</section>