@php
    // $section is available from the page renderer
    // Default values for section content
    $sectionTitle = $section->content['title'] ?? 'Featured Products';
    $numberOfProducts = (int)($section->content['number_of_items'] ?? 4);
    $displayType = $section->content['display_type'] ?? 'featured'; // 'featured' or 'latest'
    $viewAllLink = $section->content['view_all_link'] ?? null; // e.g., '/products'
    $viewAllText = $section->content['view_all_text'] ?? 'View All Products';

    // Fetch products from BusinessDirectory module
    try {
        $productsQuery = \Modules\BusinessDirectory\Entities\Product::query()
            ->where('status', 'published'); // Assuming 'published' is the status for active products

        if ($displayType === 'featured') {
            $productsQuery->where('is_featured', true);
        }

        $products = $productsQuery->with('company') // Eager load company if you display company name
            ->orderBy('created_at', 'desc') // Or a specific order field
            ->take($numberOfProducts)
            ->get();
    } catch (\Throwable $e) {
        $products = collect();
        \Illuminate\Support\Facades\Log::error("Error fetching products for landing page section: " . $e->getMessage());
    }
@endphp

@if($products->isNotEmpty())
<section class="py-12 md:py-20 bg-gray-100 dark:bg-gray-900">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        <h2 class="text-3xl font-bold text-center text-gray-800 dark:text-white mb-10">{{ $sectionTitle }}</h2>
        <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-8">
            @foreach($products as $product)
                <div class="bg-white dark:bg-gray-800 p-6 rounded-lg shadow-lg hover:shadow-xl transition-shadow duration-300 flex flex-col">
                    @if($product->images && !empty($product->images[0]))
                        {{-- Assuming images[0] stores a path relative to public storage --}}
                        <img src="{{ Storage::url($product->images[0]) }}" alt="{{ $product->name }}" class="w-full h-48 object-cover rounded-md mb-4">
                    @else
                        <div class="w-full h-48 bg-gray-200 dark:bg-gray-700 rounded-md mb-4 flex items-center justify-center">
                            <span class="text-gray-500 dark:text-gray-400">No Image</span>
                        </div>
                    @endif
                    <h3 class="text-xl font-semibold text-[var(--clr-accent)] mb-2 flex-grow">{{ $product->name }}</h3>
                    <p class="text-gray-700 dark:text-gray-300 font-bold mb-3">
                        ${{ number_format($product->sale_price ?? $product->price, 2) }}
                        @if($product->sale_price && $product->price > $product->sale_price)
                            <span class="text-sm text-gray-500 dark:text-gray-400 line-through ml-2">${{ number_format($product->price, 2) }}</span>
                        @endif
                    </p>
                    {{-- Link to the product detail page (assuming a route exists in BusinessDirectory) --}}
                    <a href="{{-- route('module.products.show', $product->slug) --}}#" class="mt-auto inline-block text-center bg-purple-600 hover:bg-purple-700 text-white font-semibold py-2 px-4 rounded-lg transition duration-300 text-sm">View Product</a>
                </div>
            @endforeach
        </div>
        @if($viewAllLink)
        <div class="text-center mt-12">
            <a href="{{ url($viewAllLink) }}" class="inline-block bg-purple-600 hover:bg-purple-700 text-white font-semibold py-3 px-8 rounded-lg transition duration-300">
                {{ $viewAllText }}
            </a>
        </div>
        @endif
    </div>
</section>
@endif