{{--
    Props:
    - $item: The MenuItem instance.
    - $level: Current depth of the menu item (0 for root).
--}}
@php
    $level = $level ?? 0;
    $hasChildren = $item->children->isNotEmpty();
    $itemLink = $item->link ?? '#';

    // Active state determination (similar to your general theme's logic)
    $isActive = false;
    if ($itemLink !== '#') {
        $currentFullUrl = rtrim(request()->fullUrl(), '/');
        $normalizedItemLink = rtrim($itemLink, '/');
        $baseAppUrl = rtrim(url('/'), '/');

        if ($currentFullUrl === $normalizedItemLink) {
            $isActive = true;
        } elseif ($normalizedItemLink !== $baseAppUrl && Str::startsWith($currentFullUrl, $normalizedItemLink . '/')) {
            $isActive = true;
        } elseif (request()->is('/') && $normalizedItemLink === $baseAppUrl) {
            $isActive = true;
        }
    }

    // Base classes for the link
    $linkBaseClasses = 'text-sm font-medium transition-colors duration-150 ease-in-out';
    $linkDefaultColor = 'text-slate-700 dark:text-slate-200 hover:text-blue-600 dark:hover:text-blue-400';
    $linkActiveColor = 'text-blue-600 dark:text-blue-400 font-semibold'; // Added font-semibold for active state

    // Classes for top-level items vs dropdown items
    $linkSpecificClasses = $level === 0
        ? 'px-1 py-2' // Adjust padding for top-level items if needed
        : 'block px-4 py-2 hover:bg-slate-100 dark:hover:bg-slate-700 w-full text-left'; // Dropdown item styling
@endphp

<li class="{{ $hasChildren && $level < 2 ? 'relative group' : '' }} {{ $level > 0 ? 'w-full' : '' }}">
    <a href="{{ $itemLink }}"
       target="{{ $item->target }}"
       class="{{ $linkBaseClasses }} {{ $isActive ? $linkActiveColor : $linkDefaultColor }} {{ $linkSpecificClasses }}">
        @if($item->icon_class)<i class="{{ $item->icon_class }} {{ $level === 0 ? 'mr-1' : 'mr-2' }}"></i>@endif
        {{ $item->title }}
        @if($hasChildren && $level === 0) {{-- Chevron only for top-level items with children --}}
            <i class="fas fa-chevron-down ml-1 text-xs opacity-70 group-hover:opacity-100 transition-opacity {{ $isActive ? 'text-blue-600 dark:text-blue-400' : 'text-slate-500 dark:text-slate-400' }}"></i>
        @endif
    </a>
    @if ($hasChildren && $level < 2) {{-- Limit dropdowns to 2 levels for simplicity --}}
        <ul class="absolute w-56 rounded-md shadow-lg py-1 bg-white dark:bg-slate-800 ring-1 ring-black ring-opacity-5 hidden group-hover:block z-50
                   {{ $level === 0 ? 'left-0 top-full mt-1' : 'left-full top-0 ml-1' }}"> {{-- Adjusted margin/positioning for dropdown --}}
            @foreach ($item->children as $child)
                <x-landingpage::themes.job_board.partials.menu-item-frontend :item="$child" :level="$level + 1" />
            @endforeach
        </ul>
    @endif
</li>
