@extends('landingpage::themes.job_board.layouts.master')

@php
    // $jobs is paginated collection from PublicPageController
    // $pageTitle is also from PublicPageController
    // $metaDescription is also from PublicPageController
    // $activeTheme is available

    // Construct a $page object for compatibility with header/menu partials if they expect it
    // This is a simplified version for listing pages.
    $page = (object) [
        'title' => $pageTitle ?? 'Job Listings',
        'meta_title' => $pageTitle ?? 'Job Listings - ' . setting('site_name'),
        'meta_description' => $metaDescription ?? 'Find the latest job opportunities.',
        'meta_keywords' => 'jobs, careers, employment, job listings',
        'slug' => 'jobs' // Or fetch from a dedicated LpPage if you have one for /jobs
    ];
@endphp

@section('theme_content')
<div class="bg-slate-50 dark:bg-slate-900 py-12 md:py-16">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        <header class="mb-10 text-center">
            <h1 class="text-4xl font-bold tracking-tight text-slate-900 dark:text-slate-100 sm:text-5xl">
                {{ $page->title }}
            </h1>
            @if($page->meta_description)
            <p class="mt-3 text-lg leading-8 text-slate-600 dark:text-slate-300">
                {{ $page->meta_description }}
            </p>
            @endif
        </header>

        {{-- Search/Filter Bar for Jobs --}}
        <div class="mb-10 bg-white dark:bg-slate-800 p-6 rounded-lg shadow-md">
            <form action="{{ route('landingpage.jobs.index') }}" method="GET" class="grid grid-cols-1 md:grid-cols-3 gap-4 items-end">
                <div>
                    <label for="keywords" class="block text-sm font-medium text-slate-700 dark:text-slate-300">Keywords</label>
                    <input type="text" name="keywords" id="keywords" value="{{ request('keywords') }}" placeholder="e.g., Developer, Manager" class="mt-1 block w-full rounded-md border-slate-300 dark:border-slate-600 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm dark:bg-slate-700 dark:text-slate-200">
                </div>
                <div>
                    <label for="location" class="block text-sm font-medium text-slate-700 dark:text-slate-300">Location</label>
                    <input type="text" name="location" id="location" value="{{ request('location') }}" placeholder="e.g., New York, Remote" class="mt-1 block w-full rounded-md border-slate-300 dark:border-slate-600 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm dark:bg-slate-700 dark:text-slate-200">
                </div>
                <button type="submit" class="w-full md:w-auto bg-blue-600 hover:bg-blue-700 text-white font-semibold py-2.5 px-4 rounded-md text-sm shadow-sm transition duration-150">Search Jobs</button>
            </form>
        </div>

        @if($jobs->isNotEmpty())
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6 lg:gap-8">
                @foreach($jobs as $job)
                    <div class="bg-white dark:bg-slate-800 rounded-lg shadow-lg overflow-hidden hover:shadow-xl transition-shadow duration-300 ease-in-out">
                        <div class="p-6">
                            <h2 class="text-xl font-semibold text-slate-900 dark:text-slate-100 mb-1">
                                <a href="{{ route('theme.job.show', $job->slug) }}" class="hover:text-blue-600 dark:hover:text-blue-400 transition-colors">
                                    {{ $job->title }}
                                </a>
                            </h2>
                            @if($job->company)
                                <p class="text-sm text-slate-600 dark:text-slate-400 mb-3">
                                    <a href="{{ route('theme.company.show', $job->company->slug) }}" class="hover:underline">{{ $job->company->name }}</a>
                                </p>
                            @endif
                            <p class="text-sm text-slate-500 dark:text-slate-400 mb-1"><i class="fas fa-map-marker-alt mr-2 text-slate-400"></i>{{ $job->location ?: 'Not specified' }}</p>
                            <p class="text-sm text-slate-500 dark:text-slate-400 mb-3"><i class="fas fa-briefcase mr-2 text-slate-400"></i>{{ $job->job_type ? Str::title($job->job_type) : 'Not specified' }}</p>
                            <a href="{{ route('theme.job.show', $job->slug) }}" class="inline-block text-sm font-medium text-blue-600 dark:text-blue-400 hover:text-blue-700 dark:hover:text-blue-300">
                                View Details <i class="fas fa-arrow-right ml-1"></i>
                            </a>
                        </div>
                    </div>
                @endforeach
            </div>

            <div class="mt-12">
                {{ $jobs->links('landingpage::themes.job_board.partials.pagination') }} {{-- Custom pagination view --}}
            </div>
        @else
            <p class="text-center text-slate-500 dark:text-slate-400 text-lg">No job listings found at the moment. Please check back later.</p>
        @endif
    </div>
</div>
@endsection