@extends("landingpage::themes.{$activeTheme}.layouts.app")

@php
    // $page is the LpPage instance (which might just be a wrapper or could hold some intro content)
    // $businessData is passed from FrontendPageController, ideally containing ['project' => ProjectObject]
    // Or, if $page itself is the project data source:
    $project = $businessData['project'] ?? $page ?? null; // Prioritize $businessData if available

    $projectName = $project->name ?? $project->title ?? 'Project Details';
    $projectDescription = $project->full_description ?? $project->description ?? $project->content ?? 'No description available.';
    $featuredImageUrl = $project->featured_image_url ?? 'https://via.placeholder.com/1200x600.png?text=' . urlencode($projectName);
    $instructionsToTest = $project->test_instructions ?? null;
    $testLinks = $project->test_links ?? []; // Expects an array of ['title' => 'Live Demo', 'url' => '...']
    $customerSupportInfo = $project->customer_support_info ?? null;
    $canyonUrl = $project->canyon_url ?? null;
    $technologies = $project->technologies_used ?? []; // Expects an array of strings or objects with name/icon
@endphp

@if($project)
    @section('meta_title', $project->meta_title ?: $projectName)
    @section('meta_description', $project->meta_description ?: \Illuminate\Support\Str::limit(strip_tags($projectDescription), 160))

    @push('schema_markup')
    <script type="application/ld+json">
    {
      "@context": "https://schema.org",
      "@type": "SoftwareApplication", // Or "Product" if more appropriate
      "name": "{{ $projectName }}",
      "description": "{{ \Illuminate\Support\Str::limit(strip_tags($projectDescription), 200) }}",
      "image": "{{ $featuredImageUrl }}",
      "url": "{{ url()->current() }}",
      @if($canyonUrl)
      "offers": {
        "@type": "Offer",
        "url": "{{ $canyonUrl }}",
        "seller": {
          "@type": "Organization",
          "name": "CodeCanyon"
        }
      },
      @endif
      "applicationCategory": "Software", // Be more specific if possible
      "operatingSystem": "Web", // Or "iOS", "Android", etc.
      "publisher": {
        "@type": "Organization",
        "name": "{{ setting('site_name', 'Digital Vocano') }}"
      }
    }
    </script>
    @endpush

@section('content')
<div class="bg-gray-50 dark:bg-gray-900 pt-8 pb-16 md:pt-12 md:pb-24">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        <article class="max-w-4xl mx-auto bg-white dark:bg-gray-800 shadow-xl rounded-lg overflow-hidden">
            <header class="p-6 md:p-8 border-b border-gray-200 dark:border-gray-700">
                <h1 class="text-3xl md:text-4xl font-bold text-gray-900 dark:text-white mb-3">{{ $projectName }}</h1>
                @if($project->short_description ?? null)
                    <p class="text-lg text-gray-600 dark:text-gray-400">{{ $project->short_description }}</p>
                @endif
            </header>

            <img src="{{ $featuredImageUrl }}" alt="Featured image for {{ $projectName }}" class="w-full h-auto max-h-[500px] object-cover">

            <div class="p-6 md:p-8">
                <section class="mb-8">
                    <h2 class="text-2xl font-semibold text-gray-800 dark:text-gray-200 mb-4">Project Overview</h2>
                    <div class="prose prose-lg lg:prose-xl dark:prose-invert max-w-none text-gray-700 dark:text-gray-300">
                        {!! $projectDescription !!}
                    </div>
                </section>

                @if($instructionsToTest)
                <section class="mb-8">
                    <h2 class="text-2xl font-semibold text-gray-800 dark:text-gray-200 mb-4">Testing Instructions</h2>
                    <div class="prose dark:prose-invert max-w-none text-gray-700 dark:text-gray-300 bg-gray-100 dark:bg-gray-700/50 p-4 rounded-md">
                        {!! $instructionsToTest !!}
                    </div>
                </section>
                @endif

                @if(!empty($testLinks))
                <section class="mb-8">
                    <h2 class="text-2xl font-semibold text-gray-800 dark:text-gray-200 mb-4">Test & Preview Links</h2>
                    <ul class="space-y-2">
                        @foreach($testLinks as $link)
                        <li>
                            <a href="{{ $link['url'] }}" target="_blank" rel="noopener noreferrer" class="inline-flex items-center text-purple-600 dark:text-purple-400 hover:text-purple-700 dark:hover:text-purple-300 font-medium">
                                {{ $link['title'] }}
                                <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 ml-1.5" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2"><path stroke-linecap="round" stroke-linejoin="round" d="M10 6H6a2 2 0 00-2 2v10a2 2 0 002 2h10a2 2 0 002-2v-4M14 4h6m0 0v6m0-6L10 14" /></svg>
                            </a>
                        </li>
                        @endforeach
                    </ul>
                </section>
                @endif

                @if($customerSupportInfo)
                <section class="mb-8">
                    <h2 class="text-2xl font-semibold text-gray-800 dark:text-gray-200 mb-4">Customer Support</h2>
                    <div class="prose dark:prose-invert max-w-none text-gray-700 dark:text-gray-300">
                        {!! $customerSupportInfo !!}
                    </div>
                </section>
                @endif

                @if($canyonUrl)
                <div class="mt-10 text-center">
                    <a href="{{ $canyonUrl }}" target="_blank" rel="noopener noreferrer" class="inline-block bg-green-500 hover:bg-green-600 text-white font-bold py-3 px-8 rounded-lg text-lg shadow-md hover:shadow-lg transition-colors duration-300">
                        Buy on CodeCanyon
                    </a>
                </div>
                @endif
            </div>
        </article>
    </div>
</div>
@endsection
@else
    @section('meta_title', 'Project Not Found')
    @section('content')
    <div class="container mx-auto px-4 py-16 text-center">
        <h1 class="text-3xl font-semibold text-gray-800 dark:text-gray-100 mb-6">Project Not Found</h1>
        <p class="text-gray-600 dark:text-gray-400 mb-8">Sorry, the project you are looking for could not be found.</p>
        <a href="{{ url('/') }}" class="bg-purple-600 hover:bg-purple-700 text-white font-semibold py-3 px-6 rounded-lg transition duration-300">Go to Homepage</a>
    </div>
    @endsection
@endif