{{--
    Card Grid Layout
    Expects $section and $content.
    Content fields:
    - title (section title, optional)
    - title_tag (optional, defaults to 'h2')
    - subtitle (section subtitle, optional)
    - items (required array of card data)
        Each item in 'items' can have:
        - item_image_url (optional)
        - item_image_alt (optional)
        - item_icon_class (optional, e.g., 'fas fa-check text-green-500')
        - item_title (required)
        - item_description (optional)
        - item_link (optional)
        - item_link_text (optional, defaults to 'Learn More')
    - grid_cols_sm (optional, defaults to 'grid-cols-1')
    - grid_cols_md (optional, defaults to 'md:grid-cols-2')
    - grid_cols_lg (optional, defaults to 'lg:grid-cols-3')
    - card_bg_color (optional, defaults to 'bg-white dark:bg-gray-800')
    - card_text_color (optional, defaults to 'text-gray-700 dark:text-gray-200')
    - card_shadow (optional, defaults to 'shadow-lg hover:shadow-xl')
--}}
@php
    $titleTag = $content['title_tag'] ?? 'h2';
    $gridColsSm = $content['grid_cols_sm'] ?? 'grid-cols-1';
    $gridColsMd = $content['grid_cols_md'] ?? 'md:grid-cols-2';
    $gridColsLg = $content['grid_cols_lg'] ?? 'lg:grid-cols-3';
    $cardBgColor = $content['card_bg_color'] ?? 'bg-white dark:bg-slate-800'; // Adjusted for consistency
    $cardTextColor = $content['card_text_color'] ?? 'text-slate-700 dark:text-slate-200';
    $cardShadow = $content['card_shadow'] ?? 'shadow-lg hover:shadow-xl';
@endphp

<section id="section-{{ $section->id }}" class="py-12 md:py-20 {{ $content['bg_color'] ?? 'bg-gray-50 dark:bg-gray-900' }} {{ $content['text_color'] ?? 'text-gray-800 dark:text-gray-100' }}">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        @if(!empty($content['title']))
            <{{ $titleTag }} class="text-3xl md:text-4xl font-bold {{ $content['title_align'] ?? 'text-center' }} mb-4">{{ $content['title'] }}</{{ $titleTag }}>
        @endif
        @if(!empty($content['subtitle']))
            <p class="text-lg {{ $content['subtitle_align'] ?? 'text-center' }} text-gray-600 dark:text-gray-400 mb-12 max-w-2xl {{ ($content['subtitle_align'] ?? 'text-center') == 'text-center' ? 'mx-auto' : '' }}">{{ $content['subtitle'] }}</p>
        @endif

        @if(!empty($content['items']) && is_array($content['items']))
            <div class="grid {{ $gridColsSm }} {{ $gridColsMd }} {{ $gridColsLg }} gap-8 md:gap-10">
                @foreach($content['items'] as $item)
                    <div class="{{ $cardBgColor }} {{ $cardTextColor }} rounded-xl {{ $cardShadow }} transition-shadow duration-300 flex flex-col overflow-hidden p-6">
                        @if(!empty($item['item_image_url']))
                            <img src="{{ $item['item_image_url'] }}" alt="{{ $item['item_image_alt'] ?? $item['item_title'] ?? '' }}" class="w-full h-48 object-cover rounded-md mb-4">
                        @elseif(!empty($item['item_icon_class']))
                            <div class="text-center mb-4"><i class="{{ $item['item_icon_class'] }} text-4xl {{ $content['accent_color'] ?? 'text-purple-600 dark:text-purple-400' }}"></i></div>
                        @endif
                        <h3 class="text-xl font-semibold mb-2 {{ $content['accent_color'] ?? 'text-purple-600 dark:text-purple-400' }}">{{ $item['item_title'] ?? 'Card Title' }}</h3>
                        @if(!empty($item['item_description']))
                            <p class="text-sm mb-4 flex-grow">{{ $item['item_description'] }}</p>
                        @endif
                        @if(!empty($item['item_link']))
                            <div class="mt-auto">
                                <a href="{{ $item['item_link'] }}" class="inline-block {{ $content['button_class'] ?? 'text-purple-600 hover:text-purple-700 dark:text-purple-400 dark:hover:text-purple-300' }} font-medium text-sm transition-colors duration-300">
                                    {{ $item['item_link_text'] ?? 'Learn More' }} &rarr;
                                </a>
                            </div>
                        @endif
                    </div>
                @endforeach
            </div>
        @endif
    </div>
</section>