@extends("landingpage::themes.{$activeTheme}.layouts.app")

@section('meta_title', $pageTitle ?? 'Our Portfolio')
@section('meta_description', $metaDescription ?? 'Discover the innovative projects by DigitalVocano.')

@section('content')
<div class="bg-gray-50 dark:bg-gray-900 py-12 md:py-20">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        <header class="mb-12 text-center">
            <h1 class="text-4xl font-bold text-gray-800 dark:text-white">{{ $pageTitle ?? 'Our Portfolio' }}</h1>
            @if(isset($metaDescription))
            <p class="mt-4 text-lg text-gray-600 dark:text-gray-300">{{ $metaDescription }}</p>
            @endif
        </header>

        @if($portfolioProjects->isNotEmpty())
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-10 mb-12">
                @foreach($portfolioProjects as $dvProject)
                    <div class="bg-white dark:bg-gray-800 rounded-xl shadow-xl overflow-hidden hover:shadow-2xl transition-shadow duration-300 flex flex-col">
                        @if($dvProject->featured_image_url)
                            <a href="{{-- route('portfolio.project.show', $dvProject->slug) --}}#" class="block aspect-video"> {{-- Link to detail page --}}
                                <img src="{{ $dvProject->featured_image_url }}" alt="{{ $dvProject->name }}" class="w-full h-full object-cover">
                            </a>
                        @else
                            <div class="aspect-video bg-gray-200 dark:bg-gray-700 flex items-center justify-center">
                                <span class="text-gray-500 dark:text-gray-400">No Image</span>
                            </div>
                        @endif
                        <div class="p-6 flex flex-col flex-grow">
                            <h2 class="text-2xl font-semibold text-gray-800 dark:text-white mb-3">
                                <a href="{{-- route('portfolio.project.show', $dvProject->slug) --}}#" class="hover:text-[var(--clr-accent)]">
                                    {{ $dvProject->name }}
                                </a>
                            </h2>
                            <p class="text-gray-600 dark:text-gray-400 text-sm mb-5 flex-grow">
                                {{ Str::limit($dvProject->short_description ?? 'An innovative project by DigitalVocano.', 120) }}
                            </p>
                            <div class="mt-auto flex items-center space-x-4">
                                <a href="{{-- route('portfolio.project.show', $dvProject->slug) --}}#" class="inline-block bg-purple-600 hover:bg-purple-700 text-white font-semibold py-2 px-5 rounded-lg transition duration-300 text-sm">
                                    Learn More
                                </a>
                                @if($dvProject->demo_url)
                                    <a href="{{ $dvProject->demo_url }}" target="_blank" rel="noopener noreferrer" class="text-green-600 hover:text-green-700 dark:text-green-400 dark:hover:text-green-300 font-medium text-sm flex items-center">
                                        <svg class="w-4 h-4 mr-1.5" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 6H6a2 2 0 00-2 2v10a2 2 0 002 2h10a2 2 0 002-2v-4M14 4h6m0 0v6m0-6L10 14"></path></svg>
                                        Live Demo
                                    </a>
                                @endif
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
            <div class="mt-8">
                {{ $portfolioProjects->links() }}
            </div>
        @else
            <p class="text-center text-gray-600 dark:text-gray-400 text-xl">Our portfolio is currently being updated. Please check back soon!</p>
        @endif
    </div>
</div>
@endsection