{{--
    $item: The MenuItem instance.
    $level: Current depth of the menu item (0 for root).
--}}
@php
    $level = $level ?? 0; // Ensure $level is set, default to 0 if not passed
@endphp

<li class="{{ $item->children->isNotEmpty() && $level < 2 ? 'relative group' : '' }} {{ $level > 0 ? 'w-full' : '' }}">
    <a href="{{ $item->link }}"
       target="{{ $item->target }}"
       style="{{ request()->fullUrlIs($item->link . '*') || (request()->is('/') && $item->link == url('/')) ? 'background-color: color-mix(in srgb, var(--clr-accent) 15%, transparent); color: var(--clr-accent);' : 'color: var(--clr-header-text);' }}"
       class="block px-3 py-2 rounded-md text-sm font-medium transition-colors duration-150 ease-in-out hover:bg-gray-100 dark:hover:bg-gray-700 hover:text-[var(--clr-accent)] dark:hover:text-[var(--clr-accent)]
              {{ $level > 0 ? 'w-full text-left' : 'inline-block' }}">
        @if($item->icon_class)<i class="{{ $item->icon_class }} mr-2"></i>@endif
        {{ $item->title }}
        @if($item->children->isNotEmpty() && $level < 1) {{-- Show dropdown icon only for top level with children --}}
            <i class="fas fa-chevron-down ml-1 text-xs opacity-70 group-hover:opacity-100 transition-opacity" style="color: var(--clr-header-text);"></i>
        @endif
    </a>
    @if ($item->children->isNotEmpty() && $level < 2) {{-- Limit dropdowns to 2 levels for simplicity in this example --}}
        <ul style="background-color: var(--clr-header-bg); border-color: color-mix(in srgb, var(--clr-header-text) 20%, transparent);"
            class="absolute w-56 rounded-md shadow-lg py-1 hidden group-hover:block z-50 border
                   {{ $level === 0 ? 'left-0 top-full' : '' }}
                   {{ $level === 1 ? 'left-full top-0 border-l' : '' }}
                   ">
            @foreach ($item->children as $child)
                @include('landingpage::themes.general.partials.menu-item-frontend', ['item' => $child, 'level' => $level + 1])
            @endforeach
        </ul>
    @endif
</li>