@extends("landingpage::themes.{$activeTheme}.layouts.app")

@php
    // $page is passed from FrontendPageController
@endphp

@section('meta_title', $page->meta_title ?: $page->title)
@section('meta_description', $page->meta_description ?: setting('landingpage_global_meta_description'))
@section('meta_keywords', $page->meta_keywords ?: setting('landingpage_global_meta_keywords'))

@push('schema_markup')
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "{{ $page->schema_type ?? 'WebPage' }}", {{-- You could add a schema_type field to LpPage model for more specific types like AboutPage, ContactPage, ServicePage --}}
  "name": "{{ $page->meta_title ?: $page->title }}",
  "headline": "{{ $page->title }}",
  "description": "{{ $page->meta_description ?: setting('landingpage_global_meta_description') }}",
  "url": "{{ url()->current() }}",
  @if($page->featured_image_url)
  "image": {
    "@type": "ImageObject",
    "url": "{{ $page->featured_image_url }}"
  },
  @endif
  "datePublished": "{{ $page->created_at->toIso8601String() }}",
  "dateModified": "{{ $page->updated_at->toIso8601String() }}",
  "mainEntityOfPage": {
    "@type": "WebPage",
    "@id": "{{ url()->current() }}"
  },
   "publisher": {
    "@type": "Organization",
    "name": "{{ setting('site_name', config('app.name')) }}",
    "url": "{{ url('/') }}",
    @if(setting('site_logo') && \Illuminate\Support\Facades\Storage::disk('public')->exists(str_replace(\Illuminate\Support\Facades\Storage::url(''), '', setting('site_logo'))))
    "logo": {
      "@type": "ImageObject",
      "url": "{{ \Illuminate\Support\Facades\Storage::url(setting('site_logo')) }}"
    }
    @endif
  }
}
</script>
@endpush

@section('content')
    @php
        // Eager load sections if not already loaded
        if (!$page->relationLoaded('sections')) {
            $page->load('sections');
        }
        $dynamicHeroSection = $page->sections->where('type', 'hero')->sortBy('sort_order')->first();
    @endphp

    {{-- Attempt to render a dynamic hero section first --}}
    @if ($dynamicHeroSection && isset($dynamicHeroSection->content))
        <x-landingpage::landing-page-section :section="$dynamicHeroSection" :activeTheme="$activeTheme" />
    {{-- Fallback to default hero fields on the LpPage model if they exist and no dynamic hero section --}}
    @elseif ($page->hero_title)
        <section class="default-hero-section bg-slate-100 dark:bg-slate-700 py-16 md:py-24 text-center">
            <div class="container mx-auto px-4 sm:px-6 lg:px-8">
                <h1 class="text-3xl md:text-4xl lg:text-5xl font-bold text-slate-800 dark:text-white mb-6">{{ $page->hero_title }}</h1>
                @if($page->hero_subtitle)
                    <p class="text-lg md:text-xl text-slate-600 dark:text-slate-300 mb-8 max-w-2xl mx-auto">{{ $page->hero_subtitle }}</p>
                @endif
                @if($page->hero_cta_text && $page->hero_cta_link)
                    <a href="{{ $page->hero_cta_link }}" class="inline-block bg-purple-600 hover:bg-purple-700 text-white font-semibold py-3 px-8 rounded-lg text-lg shadow-md hover:shadow-lg transition-all duration-300">
                        {{ $page->hero_cta_text }}
                    </a>
                @endif
            </div>
        </section>
    @else
        {{-- Standard Page Title if no hero section (dynamic or default) is present --}}
        <div class="bg-slate-100 dark:bg-slate-700 py-12 md:py-16">
            <div class="container mx-auto px-4 sm:px-6 lg:px-8">
                <h1 class="text-3xl md:text-4xl lg:text-5xl font-bold text-slate-800 dark:text-white text-center">{{ $page->title }}</h1>
            </div>
        </div>
    @endif

    {{-- Render other dynamic sections (excluding the hero if handled above) --}}
    @if($page->sections->where('type', '!=', 'hero')->count() > 0)
        @foreach ($page->sections->where('type', '!=', 'hero')->sortBy('sort_order') as $section)
            @if (isset($section->content))
                <x-landingpage::landing-page-section :section="$section" :activeTheme="$activeTheme" />
            @endif
        @endforeach
    @endif

    {{-- Main Page Content (from WYSIWYG) - Render if no dynamic sections OR if dynamic sections are meant to supplement it --}}
    {{-- If you want this content to always show, even with sections, remove the sections count check. --}}
    {{-- If sections replace this content, keep the check or adjust logic. --}}
    @if($page->content && ($page->sections->where('type', '!=', 'hero')->count() == 0 || setting('landingpage_render_main_content_with_sections', false)))
        <div class="bg-white dark:bg-gray-800 py-12 md:py-20">
            <div class="container mx-auto px-4 sm:px-6 lg:px-8">
                <div class="max-w-4xl mx-auto">
                    @if($page->featured_image_url && !$dynamicHeroSection && !$page->hero_title) {{-- Show featured image if no hero was rendered --}}
                        <img src="{{ $page->featured_image_url }}" alt="{{ $page->title }}" class="w-full rounded-lg shadow-lg mb-10 max-h-[500px] object-cover">
                    @endif
                    <article class="prose prose-lg lg:prose-xl dark:prose-invert max-w-none text-gray-700 dark:text-gray-300">
                        {!! $page->content !!}
                    </article>
                </div>
            </div>
        </div>
    @endif
@endsection
