<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" dir="{{ $siteDirection ?? 'ltr' }}" x-data="{
        // Initialize darkMode state from localStorage or system preference.
        // If localStorage has 'darkMode', use it. Otherwise, check system preference.
        darkMode: localStorage.getItem('darkMode') === 'true' || 
                  (localStorage.getItem('darkMode') === null && window.matchMedia('(prefers-color-scheme: dark)').matches),
        toggleDarkMode() {
            this.darkMode = !this.darkMode;
        }
    }" 
    x-init="
        // Watch for changes in the darkMode property and update localStorage.
        $watch('darkMode', val => localStorage.setItem('darkMode', val));
        // Apply the 'dark' class to the <html> element immediately on load based on the initial darkMode state.
        // This helps prevent a Flash Of Unstyled Content (FOUC).
        if (darkMode) {
            document.documentElement.classList.add('dark');
        } else {
            document.documentElement.classList.remove('dark');
        }"
    :class="{ 'dark': darkMode }">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <meta name="csrf-token" content="{{ csrf_token() }}" />

    @php
    // Determine current page object, default to an empty object if not set (e.g., for theme's hardcoded home)
    $currentPage = $page ?? new \Modules\LandingPage\Entities\LpPage();
    $siteName = setting('site_name', config('app.name'));
    $titleSuffix = setting('landingpage_seo_title_suffix', $siteName);
    $globalDescription = setting('landingpage_global_meta_description', 'Welcome to ' . $siteName);
    $globalKeywords = setting('landingpage_global_meta_keywords', 'website, services, products');
    @endphp

    <title>@yield('meta_title', ($currentPage->meta_title ?: $currentPage->title ?: $siteName) . ($titleSuffix ? ' - ' . $titleSuffix : ''))</title>
    <meta name="description" content="@yield('meta_description', $currentPage->meta_description ?: $globalDescription)" />
    <meta name="keywords" content="@yield('meta_keywords', $currentPage->meta_keywords ?: $globalKeywords)" />
    <link rel="canonical" href="{{ url()->current() }}" />

    {{-- Open Graph / Facebook --}}
    <meta property="og:type" content="@yield('og_type', 'website')" />
    <meta property="og:url" content="{{ url()->current() }}" />
    <meta property="og:title" content="@yield('og_title', $currentPage->meta_title ?: $currentPage->title ?: $siteName)" />
    <meta property="og:description" content="@yield('og_description', $currentPage->meta_description ?: $globalDescription)" />
    @if (isset($currentPage) && $currentPage->featured_image_url)
    <meta property="og:image" content="{{ $currentPage->featured_image_url }}" />
    @elseif(setting('site_og_image') && \Illuminate\Support\Facades\Storage::disk('public')->exists(str_replace(\Illuminate\Support\Facades\Storage::url(''), '', setting('site_og_image'))))
    <meta property="og:image" content="{{ \Illuminate\Support\Facades\Storage::url(setting('site_og_image')) }}" />
    @elseif(setting('site_logo') && \Illuminate\Support\Facades\Storage::disk('public')->exists(str_replace(\Illuminate\Support\Facades\Storage::url(''), '', setting('site_logo'))))
    <meta property="og:image" content="{{ \Illuminate\Support\Facades\Storage::url(setting('site_logo')) }}" />
    @endif

    {{-- Twitter --}}
    <meta name="twitter:card" content="summary_large_image" />
    <meta name="twitter:url" content="{{ url()->current() }}" />
    <meta name="twitter:title" content="@yield('twitter_title', $currentPage->meta_title ?: $currentPage->title ?: $siteName)" />
    <meta name="twitter:description" content="@yield('twitter_description', $currentPage->meta_description ?: $globalDescription)" />
    @if (isset($currentPage) && $currentPage->featured_image_url)
    <meta name="twitter:image" content="{{ $currentPage->featured_image_url }}" />
    @elseif(setting('site_og_image') && \Illuminate\Support\Facades\Storage::disk('public')->exists(str_replace(\Illuminate\Support\Facades\Storage::url(''), '', setting('site_og_image'))))
    <meta name="twitter:image" content="{{ \Illuminate\Support\Facades\Storage::url(setting('site_og_image')) }}" />
    @elseif(setting('site_logo') && \Illuminate\Support\Facades\Storage::disk('public')->exists(str_replace(\Illuminate\Support\Facades\Storage::url(''), '', setting('site_logo'))))
    <meta name="twitter:image" content="{{ \Illuminate\Support\Facades\Storage::url(setting('site_logo')) }}" />
    @endif
    {{-- Optional: Add your twitter handle --}}
    {{-- <meta name="twitter:site" content="@yourTwitterHandle"> --}}

    {{-- Favicon --}}
    @if(setting('site_favicon') && \Illuminate\Support\Facades\Storage::disk('public')->exists(str_replace(\Illuminate\Support\Facades\Storage::url(''), '', setting('site_favicon'))))
    <link rel="icon" href="{{ \Illuminate\Support\Facades\Storage::url(setting('site_favicon')) }}" />
    <link rel="apple-touch-icon" href="{{ \Illuminate\Support\Facades\Storage::url(setting('site_favicon')) }}" />
    @endif

    {{-- Schema.org markup --}}
    <script type="application/ld+json">
    {
        "@context": "https://schema.org",
        "@type": "WebSite",
        "url": "{{ url('/') }}",
        "name": "{{ $siteName }}",
        "description": "{{ $globalDescription }}",
        "potentialAction": {
            "@type": "SearchAction",
            "target": "{{ url('/search?q={search_term_string}') }}",
            "query-input": "required name=search_term_string"
        },
        "publisher": {
            "@type": "Organization",
            "name": "{{ $siteName }}",
            @if(setting('site_logo') && \Illuminate\Support\Facades\Storage::disk('public')->exists(str_replace(\Illuminate\Support\Facades\Storage::url(''), '', setting('site_logo'))))
            "logo": {
                "@type": "ImageObject",
                "url": "{{ \Illuminate\Support\Facades\Storage::url(setting('site_logo')) }}"
            }
            @endif
        },
        "mainEntityOfPage": {
            "@type": "WebPage",
            "@id": "{{ url()->current() }}"
        }
    }
    </script>
    @stack('schema_markup') {{-- For page-specific schema like Article, Product, Service --}}

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=figtree:400,500,600,700,800&display=swap" rel="stylesheet" /> {{-- Consistent font loading --}}
    
    {{-- Font Awesome for icons --}}
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" integrity="sha512-DTOQO9RWCH3ppGqcWaEA1BIZOC6xxalwEsw9c2QQeAIftl+Vegovlnee1c9QX4TctnWMn13TZye+giMm8e2LwA==" crossorigin="anonymous" referrerpolicy="no-referrer" />

    {{-- Custom Theme Colors --}}
    <style id="custom-theme-colors">
        :root {
            --clr-top-bar-bg: {{ setting('top_bar_bg_light', '#f3f4f6') }};
            --clr-top-bar-text: {{ setting('top_bar_text_light', '#374151') }};
            --clr-header-bg: {{ setting('header_bg_light', '#ffffff') }};
            --clr-header-text: {{ setting('header_text_light', '#374151') }};
            --clr-accent: {{ setting('accent_color_light', '#7c3aed') }};
            --clr-body-bg: #f9fafb; /* Corresponds to bg-gray-50 */
            --clr-body-text: #1f2937; /* Corresponds to text-gray-800 */
        }

        .dark {
            --clr-top-bar-bg: {{ setting('top_bar_bg_dark', '#111827') }};
            --clr-top-bar-text: {{ setting('top_bar_text_dark', '#d1d5db') }};
            --clr-header-bg: {{ setting('header_bg_dark', 'rgba(31, 41, 55, 0.95)') }}; /* Default was dark:bg-gray-800/95 */
            --clr-header-text: {{ setting('header_text_dark', '#d1d5db') }};
            --clr-accent: {{ setting('accent_color_dark', '#a78bfa') }};
            --clr-body-bg: #111827; /* Corresponds to dark:bg-gray-900 */
            --clr-body-text: #d1d5db; /* Corresponds to dark:text-gray-200 */
        }
    </style>


    <!-- Main App Styles & Scripts (Vite) -->
    @vite(['resources/css/app.css', 'resources/js/app.js'])

    <!-- Theme-Specific Styles (Optional) -->
    @stack('styles') {{-- Consolidated style stacks --}}

</head>
<body class="font-sans antialiased selection:bg-purple-500 selection:text-white"
      style="background-color: var(--clr-body-bg); color: var(--clr-body-text);">
      {{-- Removed Tailwind bg/text classes, using CSS vars now --}}

    <a href="#main-content" class="sr-only focus:not-sr-only focus:fixed focus:z-[9999] focus:top-4 focus:left-4 focus:px-4 focus:py-2 focus:bg-white dark:focus:bg-gray-800 focus:text-purple-600 dark:focus:text-purple-400 focus:shadow-lg focus:rounded-md"> {{-- Improved accessibility --}}
        Skip to main content
    </a>

    <div class="min-h-screen flex flex-col">
        @include("landingpage::themes.{$activeTheme}.partials.topbar") {{-- Added Top Bar --}}
        @include("landingpage::themes.{$activeTheme}.partials.header")

        <main id="main-content" class="flex-grow">
            @yield('content')
        </main>

        @include("landingpage::themes.{$activeTheme}.partials.footer") {{-- Consistent partial names --}}
    </div>
