{{--
    AI Website Maker Hero Section
    Expects $content to contain:
    - title: string
    - subtitle: string
    - cta_text: string
    - cta_link: string
    - secondary_cta_text: string (optional)
    - secondary_cta_link: string (optional)
    - background_image_url: string (URL to image)
    - text_color: string (e.g., 'text-white')
--}}
@php
    $title = $content['title'] ?? 'Create Your Stunning Website with AI';
    $subtitle = $content['subtitle'] ?? 'Launch a professional, beautiful website in minutes. No coding required. Let our AI do the heavy lifting.';
    $ctaText = $content['cta_text'] ?? 'Get Started For Free';
    $ctaLink = $content['cta_link'] ?? route('register'); // Default to register route
    $secondaryCtaText = $content['secondary_cta_text'] ?? 'See Examples';
    $secondaryCtaLink = $content['secondary_cta_link'] ?? '#'; // Placeholder
    $backgroundImageUrl = $content['background_image_url'] ?? null; // Admin will upload this
    $textColor = $content['text_color'] ?? 'text-white'; // Default text color for hero

    $bgStyle = $backgroundImageUrl ? "background-image: url('".Storage::url($backgroundImageUrl)."');" : "";
@endphp

<section
    class="relative bg-slate-800 bg-cover bg-center py-24 md:py-32 lg:py-40 {{ $textColor }}"
    style="{{ $bgStyle }}">
    <div class="absolute inset-0 bg-gradient-to-br from-sky-700/70 via-indigo-800/60 to-purple-900/70 opacity-90"></div> {{-- Overlay for better text readability --}}

    <div class="container mx-auto px-4 sm:px-6 lg:px-8 relative z-10 text-center">
        <h1 class="font-lexend text-4xl sm:text-5xl md:text-6xl font-bold mb-6 leading-tight">
            {{ $title }}
        </h1>
        <p class="text-lg sm:text-xl md:text-2xl mb-10 max-w-3xl mx-auto opacity-90">
            {{ $subtitle }}
        </p>
        <div class="flex flex-col sm:flex-row justify-center items-center space-y-4 sm:space-y-0 sm:space-x-4">
            <a href="{{ $ctaLink }}"
               class="px-8 py-3.5 bg-white text-sky-700 font-semibold rounded-lg text-lg shadow-lg hover:bg-slate-100 transition-all duration-300 transform hover:scale-105">
                {{ $ctaText }}
            </a>
            @if(!empty($secondaryCtaText) && !empty($secondaryCtaLink))
            <a href="{{ $secondaryCtaLink }}"
               class="px-8 py-3.5 bg-transparent border-2 border-white text-white font-semibold rounded-lg text-lg hover:bg-white/10 transition-all duration-300">
                {{ $secondaryCtaText }}
            </a>
            @endif
        </div>
    </div>
</section>