@php
    // Fetch the 'primary' menu or a configurable menu for the theme
    $menuName = setting('landingpage_ai_website_maker_primary_menu', 'primary');
    $menu = \Modules\LandingPage\Entities\Menu::where('location', $menuName)->orWhere('name', $menuName)->with('rootItems.childrenRecursive')->first();
    $isMobile = $isMobile ?? false; // Ensure $isMobile has a default value
@endphp

<nav class="{{ $isMobile ? 'flex flex-col space-y-1' : 'hidden md:flex space-x-8 items-center' }}">
    @if($menu && $menu->rootItems->isNotEmpty())
        @foreach($menu->rootItems as $item)
            <x-LandingPage::themes.ai_website_maker.partials.menu-item-frontend :item="$item" :page="$page ?? null" :isMobile="$isMobile" />
        @endforeach
    @else
        {{-- Fallback links if menu not found --}}
        <a href="{{ url('/') }}" class="text-sm font-medium text-slate-700 dark:text-slate-200 hover:text-sky-600 dark:hover:text-sky-400">Home</a>
        <a href="#" class="text-sm font-medium text-slate-700 dark:text-slate-200 hover:text-sky-600 dark:hover:text-sky-400">Features</a>
        <a href="#" class="text-sm font-medium text-slate-700 dark:text-slate-200 hover:text-sky-600 dark:hover:text-sky-400">Pricing</a>
    @endif
</nav>