<header x-data="{ mobileMenuOpen: false }" class="bg-white dark:bg-slate-800/50 backdrop-blur-md shadow-sm sticky top-0 z-40 transition-colors duration-300 ease-in-out border-b border-slate-200 dark:border-slate-700/50">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        <div class="flex items-center justify-between h-16 md:h-20 relative">
            {{-- Logo --}}
            <div class="flex-shrink-0">
                <a href="{{ url('/') }}" class="flex items-center">
                    @if(setting('site_logo_dark') && setting('color_scheme', 'light') === 'dark')
                        <img class="h-10 w-auto" src="{{ \Illuminate\Support\Facades\Storage::url(setting('site_logo_dark')) }}" alt="{{ setting('site_name', 'AI Site Maker') }}">
                    @elseif(setting('site_logo') && \Illuminate\Support\Facades\Storage::disk('public')->exists(str_replace(\Illuminate\Support\Facades\Storage::url(''), '', setting('site_logo'))))
                        <img class="h-10 w-auto" src="{{ \Illuminate\Support\Facades\Storage::url(setting('site_logo')) }}" alt="{{ setting('site_name', 'AI Site Maker') }}">
                    @else
                        <span class="font-lexend text-2xl font-bold text-sky-600 dark:text-sky-400">{{ setting('site_name', 'AI Site Maker') }}</span>
                    @endif
                </a>
            </div>

            {{-- Desktop Navigation --}}
            <div class="hidden md:flex md:items-center md:space-x-8">
                @include('LandingPage::themes.ai_website_maker.partials.navigation', ['page' => $page ?? null])
            </div>

            {{-- Desktop Action Buttons & Mobile Menu Toggle --}}
            <div class="flex items-center">
                <div class="hidden md:flex items-center space-x-3 ml-6">
                    <a href="{{ route('login') }}" class="text-sm font-medium text-slate-600 dark:text-slate-300 hover:text-sky-600 dark:hover:text-sky-400">Login</a>
                    <a href="{{ route('register') }}"
                       class="px-5 py-2.5 bg-sky-600 border border-transparent rounded-lg text-sm font-semibold text-white hover:bg-sky-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-sky-500 transition-all">
                        Get Started Free
                    </a>
                </div>

                {{-- Mobile Menu Button --}}
                <div class="md:hidden ml-4">
                    <button @click="mobileMenuOpen = !mobileMenuOpen" type="button" class="inline-flex items-center justify-center p-2 rounded-md text-slate-400 dark:text-slate-500 hover:text-slate-500 dark:hover:text-slate-400 hover:bg-slate-100 dark:hover:bg-slate-700 focus:outline-none focus:ring-2 focus:ring-inset focus:ring-sky-500" aria-controls="mobile-menu" aria-expanded="false">
                        <span class="sr-only">Open main menu</span>
                        {{-- Icon when menu is closed. Heroicon name: menu --}}
                        <svg x-show="!mobileMenuOpen" class="block h-6 w-6" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor" aria-hidden="true">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16" />
                        </svg>
                        {{-- Icon when menu is open. Heroicon name: x --}}
                        <svg x-show="mobileMenuOpen" class="block h-6 w-6" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor" aria-hidden="true" style="display: none;">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                        </svg>
                    </button>
                </div>
            </div>
        </div>
    </div>

    {{-- Mobile menu, show/hide based on menu state. --}}
    <div x-show="mobileMenuOpen" x-transition:enter="transition ease-out duration-200" x-transition:enter-start="opacity-0 scale-95" x-transition:enter-end="opacity-100 scale-100" x-transition:leave="transition ease-in duration-150" x-transition:leave-start="opacity-100 scale-100" x-transition:leave-end="opacity-0 scale-95" class="md:hidden absolute top-full inset-x-0 p-2 transition transform origin-top-right shadow-lg z-30" id="mobile-menu" style="display: none;">
        <div class="rounded-lg bg-white dark:bg-slate-800 ring-1 ring-black ring-opacity-5 dark:ring-slate-700 divide-y divide-slate-100 dark:divide-slate-700">
            <div class="pt-5 pb-6 px-5">
                <nav class="flex flex-col space-y-1">
                    @include('landingpage::themes.ai_website_maker.partials.navigation', ['page' => $page ?? null, 'isMobile' => true])
                </nav>
            </div>
            <div class="py-6 px-5 space-y-6">
                <a href="{{ route('register') }}" class="block w-full text-center px-5 py-3 bg-sky-600 border border-transparent rounded-lg font-semibold text-white hover:bg-sky-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-sky-500 transition-all">Get Started Free</a>
                <p class="mt-6 text-center text-base font-medium text-slate-500 dark:text-slate-400">
                    Existing customer? <a href="{{ route('login') }}" class="text-sky-600 dark:text-sky-400 hover:text-sky-500 dark:hover:text-sky-300">Login</a>
                </p>
            </div>
        </div>
    </div>
</header>