@extends('landingpage::themes.ai_website_maker.layouts.app')

{{--
    $page is the LpPage model instance.
    $activeTheme is the string name of the active theme.
    $businessData is an array of additional data fetched by FrontendPageController::getBusinessDataForPage()
--}}

@section('content')
    @if($page->sections->isNotEmpty())
        @foreach($page->sections->sortBy('order') as $section)
            <x-landingpage::landing-page-section :section="$section" :activeTheme="$activeTheme" :businessData="$businessData ?? []" />
        @endforeach
    @else
        {{-- Fallback content if no sections are defined for the page --}}
        <div class="container mx-auto px-4 sm:px-6 lg:px-8 py-12">
            <div class="prose dark:prose-invert max-w-none">
                {!! $page->content !!}
            </div>
        </div>
    @endif
@endsection