<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" class="{{ setting('color_scheme', 'light') === 'dark' ? 'dark' : '' }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    @php
        // Determine title, meta description, and keywords
        // $page is typically passed from FrontendPageController or FrontendController
        $title = isset($page) && property_exists($page, 'meta_title') && $page->meta_title ? $page->meta_title : (isset($page) && property_exists($page, 'title') ? $page->title . ' - ' . setting('site_name') : setting('site_name'));
        $metaDescription = isset($page) && property_exists($page, 'meta_description') && $page->meta_description ? $page->meta_description : setting('site_meta_description');
        $metaKeywords = isset($page) && property_exists($page, 'meta_keywords') && $page->meta_keywords ? $page->meta_keywords : setting('site_meta_keywords');
    @endphp

    <title>{{ $title }}</title>
    <meta name="description" content="{{ $metaDescription }}">
    <meta name="keywords" content="{{ $metaKeywords }}">

    <!-- Favicon -->
    @if(setting('site_favicon'))
        <link rel="icon" href="{{ \Illuminate\Support\Facades\Storage::url(setting('site_favicon')) }}" type="image/png">
    @endif

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=inter:400,500,600,700|lexend:400,500,600,700&display=swap" rel="stylesheet" />

    <!-- Styles -->
    {{-- Link to your theme-specific compiled CSS. Adjust path if needed. --}}
    {{-- You might use Vite for this in a real project --}}
    <link rel="stylesheet" href="{{ asset('themes/ai_website_maker/css/theme.css') }}"> {{-- We'll create this later --}}

    {{-- Inline styles for theme colors - consider moving to CSS file if extensive --}}
    @include('landingpage::themes.ai_website_maker.partials.theme_colors_css')

    @stack('styles')

    {{-- Google Analytics --}}
    @if(setting('ga_enabled') && setting('ga_measurement_id'))
        @include('landingpage::partials.ga-script')
    @endif
</head>
<body class="font-sans antialiased bg-slate-50 dark:bg-slate-900 text-slate-700 dark:text-slate-300 leading-normal tracking-normal">
    <div id="app" class="flex flex-col min-h-screen">

        @include('landingpage::themes.ai_website_maker.partials.header', ['page' => $page ?? null])

        <main class="flex-grow">
            @yield('content')
        </main>

        @include('landingpage::themes.ai_website_maker.partials.footer')

    </div>

    @stack('modals')
    @stack('scripts')
</body>
</html>