@extends("landingpage::themes.{$activeTheme}.layouts.app")

@section('meta_title', $pageTitle ?? 'Job Listings')
@section('meta_description', $metaDescription ?? 'Browse our latest job openings.')

@section('content')
<div class="bg-gray-50 dark:bg-gray-900 py-12 md:py-20">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        <header class="mb-12 text-center">
            <h1 class="text-4xl font-bold text-gray-800 dark:text-white">{{ $pageTitle ?? 'Job Openings' }}</h1>
            @if(isset($metaDescription))
            <p class="mt-4 text-lg text-gray-600 dark:text-gray-300">{{ $metaDescription }}</p>
            @endif
        </header>

        @if($jobs->isNotEmpty())
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8 mb-12">
                @foreach($jobs as $job)
                    <div class="bg-white dark:bg-gray-800 p-6 rounded-lg shadow-lg hover:shadow-xl transition-shadow duration-300 flex flex-col">
                        <div class="flex-grow">
                            <h2 class="text-2xl font-semibold text-[var(--clr-accent)] mb-2">
                                {{-- Link to job detail page if available --}}
                                <a href="{{-- route('module.jobs.show', $job->slug) --}}#" class="hover:underline">
                                    {{ $job->title }}
                                </a>
                            </h2>
                            @if($job->company)
                                <p class="text-sm text-gray-500 dark:text-gray-400 mb-1">Company: {{ $job->company->name }}</p>
                            @endif
                            <p class="text-sm text-gray-500 dark:text-gray-400 mb-3">Location: {{ $job->location ?? 'N/A' }}</p>
                            <p class="text-gray-600 dark:text-gray-300 text-sm mb-4">
                                {{ Str::limit($job->description ?? 'No description provided.', 120) }}
                            </p>
                        </div>
                        <div class="mt-auto">
                            <a href="{{-- route('module.jobs.show', $job->slug) --}}#" class="inline-block mt-4 text-purple-500 hover:text-purple-700 dark:hover:text-purple-300 font-semibold text-sm">
                                View Details &rarr;
                            </a>
                        </div>
                    </div>
                @endforeach
            </div>
            {{-- Pagination Links --}}
            <div class="mt-8">
                {{ $jobs->links() }} {{-- Ensure Tailwind pagination views are set up in AppServiceProvider --}}
            </div>
        @else
            <p class="text-center text-gray-600 dark:text-gray-400 text-xl">No job openings found at the moment. Please check back later.</p>
        @endif
    </div>
</div>
@endsection