@extends("landingpage::themes.{$activeTheme}.layouts.app")

@php
    // $page is passed from FrontendPageController
    // You might fetch additional solution-specific data here or in the controller
    // For example, related case studies, technical specifications, etc.
@endphp

@section('meta_title', ($page->meta_title ?: $page->title) . ' - AI Solution')
@section('meta_description', $page->meta_description ?: 'Detailed information about our ' . $page->title . ' AI solution.')

@push('schema_markup')
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "Service", // Or "Product" if it's more product-like
  "name": "{{ $page->title }}",
  "description": "{{ $page->meta_description ?: 'Detailed information about our ' . $page->title . ' AI solution.' }}",
  @if($page->featured_image_url)
  "image": "{{ $page->featured_image_url }}",
  @endif
  "url": "{{ url()->current() }}",
  "provider": {
    "@type": "Organization",
    "name": "{{ setting('site_name', 'AI Startup Inc.') }}"
  }
  // Add more properties like "serviceType", "areaServed", "offers" (for pricing)
}
</script>
@endpush

@section('content')
<div class="bg-gray-800 dark:bg-gray-900/70 pt-24 md:pt-32 pb-12 md:pb-20">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        <div class="max-w-5xl mx-auto">
            {{-- Breadcrumbs or Back Link --}}
            <div class="mb-8">
                <a href="{{ route('landingpage.page.show', 'solutions') }}" class="text-blue-400 dark:text-blue-300 hover:underline text-sm">&larr; Back to Solutions Overview</a>
            </div>

            <article class="bg-gray-800/50 dark:bg-gray-900/80 p-6 sm:p-8 md:p-12 rounded-xl shadow-2xl border border-gray-700 dark:border-gray-800">
                <h1 class="text-3xl md:text-4xl lg:text-5xl font-bold mb-6 text-white">{{ $page->title }}</h1>

                @if($page->featured_image_url)
                    <img src="{{ $page->featured_image_url }}" alt="{{ $page->title }}" class="w-full rounded-lg shadow-lg mb-8 max-h-[450px] object-cover">
                @endif

                <div class="prose prose-lg lg:prose-xl prose-invert max-w-none text-gray-300 dark:text-gray-200 mb-10">
                    {!! $page->content !!} {{-- Main content describing the solution --}}
                </div>

                {{-- Solution-Specific Sections (Example) --}}
                <section class="mt-10 pt-8 border-t border-gray-700 dark:border-gray-800">
                    <h2 class="text-2xl font-semibold text-white mb-4">Key Features & Benefits</h2>
                    {{-- Placeholder: list features, benefits, tech stack, case studies related to this solution --}}
                    <ul class="list-disc list-inside text-gray-300 dark:text-gray-200 space-y-2">
                        <li>Feature A: Solves problem X with Y technology.</li>
                        <li>Benefit B: Increases efficiency by Z%.</li>
                        <li>Technology Stack: Python, TensorFlow, Kubernetes.</li>
                    </ul>
                </section>
            </article>
        </div>
    </div>
</div>
@endsection