@php
    $homepageSlug = setting('landingpage_homepage_slug', 'home');
    // Fetch the menu assigned to the 'primary_navigation' location
    $primaryMenu = \Modules\LandingPage\Entities\Menu::where('location', 'primary_navigation')
                                                    ->with(['rootItems' => function ($query) {
                                                        $query->where('is_active', true) // Assuming you have an is_active flag
                                                              ->orderBy('sort_order', 'asc')
                                                              ->with(['children' => function($q) { // 1st level children
                                                                  $q->where('is_active', true)->orderBy('sort_order', 'asc')
                                                                    ->with(['children' => function($q2){ // 2nd level children
                                                                        $q2->where('is_active', true)->orderBy('sort_order', 'asc');
                                                                    }]);
                                                              }]);
                                                    }])
                                                    ->first();
@endphp

<header style="background-color: var(--clr-header-bg); color: var(--clr-header-text);" class="shadow-lg sticky top-0 z-[100] backdrop-blur-md transition-all duration-300 ease-in-out"
        x-data="{ openMobileMenu: false, atTop: true }"
        @scroll.window="atTop = (window.pageYOffset < 50)">
    <div class="container mx-auto px-4 sm:ps-6 sm:pe-6 lg:ps-8 lg:pe-8"> {{-- Changed px to ps/pe for directional padding --}}
        <div class="flex justify-between items-center w-full py-4" :class="{ 'py-3': !atTop, 'py-4': atTop }"> {{-- This container handles overall spacing --}}
            {{-- Logo --}}
            <div class="flex-shrink-0">
                <a href="{{ url('/') }}" style="color: var(--clr-accent);" class="text-2xl font-bold hover:opacity-80 transition-opacity" aria-label="Homepage">
                    @php
                        $siteLogoRelativePath = setting('site_logo');
                        $siteName = setting('site_name', config('app.name', 'Digital Vocano'));
                    @endphp
                    @if($siteLogoRelativePath && Storage::disk('public')->exists($siteLogoRelativePath))
                        <img src="{{ Storage::url($siteLogoRelativePath) }}" alt="{{ $siteName }}" class="h-10 md:h-12 transition-all duration-300" :class="{ 'h-8 md:h-10': !atTop, 'h-10 md:h-12': atTop }">
                    @else
                        {{ $siteName }}
                    @endif
                </a>
            </div>

            {{-- Desktop Navigation --}}
            <div class="hidden md:flex items-center space-x-4 lg:space-x-6"> {{-- Increased spacing for desktop nav items --}}
                @if($primaryMenu && $primaryMenu->rootItems->isNotEmpty())
                    <ul class="flex items-center space-x-1 lg:space-x-2">
                        @foreach($primaryMenu->rootItems as $item)
                            @include('landingpage::themes.general.partials.menu-item-frontend', ['item' => $item, 'level' => 0])
                        @endforeach
                    </ul>
                @else
                    {{-- Fallback if no menu is assigned or menu is empty --}}
                    <a href="{{ url('/') }}" style="{{ request()->is('/') || request()->is($homepageSlug) ? 'background-color: color-mix(in srgb, var(--clr-accent) 15%, transparent); color: var(--clr-accent);' : 'color: var(--clr-header-text);' }}" class="px-3 py-2 rounded-md text-sm font-medium hover:bg-gray-100 dark:hover:bg-gray-700 hover:text-[var(--clr-accent)] dark:hover:text-[var(--clr-accent)] transition-colors duration-150 ease-in-out">Home</a>
                    <span style="color: var(--clr-header-text);" class="px-3 py-2 rounded-md text-sm font-medium opacity-50">Configure Menu</span>
                @endif

                <button @click="toggleDarkMode" style="color: var(--clr-header-text);" class="p-2 rounded-full hover:bg-gray-100 dark:hover:bg-gray-700 opacity-75 hover:opacity-100 focus:outline-none" aria-label="Toggle dark mode">
                    <svg x-show="!darkMode" class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20"><path d="M17.293 13.293A8 8 0 016.707 2.707a8.001 8.001 0 1010.586 10.586z"></path></svg>
                    <svg x-show="darkMode" class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M10 2a1 1 0 011 1v1a1 1 0 11-2 0V3a1 1 0 011-1zm4 8a4 4 0 11-8 0 4 4 0 018 0zm-.464 4.95l.707.707a1 1 0 001.414-1.414l-.707-.707a1 1 0 00-1.414 1.414zm2.12-10.607a1 1 0 010 1.414l-.706.707a1 1 0 11-1.414-1.414l.707-.707a1 1 0 011.414 0zM17 11a1 1 0 100-2h-1a1 1 0 100 2h1zm-7 4a1 1 0 011 1v1a1 1 0 11-2 0v-1a1 1 0 011-1zM5.05 6.464A1 1 0 106.465 5.05l-.708-.707a1 1 0 00-1.414 1.414l.707.707zm-.707 7.072l.707-.707a1 1 0 10-1.414-1.414l-.707.707a1 1 0 001.414 1.414zM3 11a1 1 0 100 2h1a1 1 0 100-2H3zM15 11a1 1 0 100-2h1a1 1 0 100 2h-1z" clip-rule="evenodd"></path></svg>
                </button>
            </div>

            {{-- Mobile Menu Button --}}
            <div class="md:hidden flex items-center">
                <button @click="toggleDarkMode" style="color: var(--clr-header-text);" class="p-2 me-2 rounded-full hover:bg-gray-100 dark:hover:bg-gray-700 opacity-75 hover:opacity-100 focus:outline-none" aria-label="Toggle dark mode">
                    <svg x-show="!darkMode" class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20"><path d="M17.293 13.293A8 8 0 016.707 2.707a8.001 8.001 0 1010.586 10.586z"></path></svg>
                    <svg x-show="darkMode" class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M10 2a1 1 0 011 1v1a1 1 0 11-2 0V3a1 1 0 011-1zm4 8a4 4 0 11-8 0 4 4 0 018 0zm-.464 4.95l.707.707a1 1 0 001.414-1.414l-.707-.707a1 1 0 00-1.414 1.414zm2.12-10.607a1 1 0 010 1.414l-.706.707a1 1 0 11-1.414-1.414l.707-.707a1 1 0 011.414 0zM17 11a1 1 0 100-2h-1a1 1 0 100 2h1zm-7 4a1 1 0 011 1v1a1 1 0 11-2 0v-1a1 1 0 011-1zM5.05 6.464A1 1 0 106.465 5.05l-.708-.707a1 1 0 00-1.414 1.414l.707.707zm-.707 7.072l.707-.707a1 1 0 10-1.414-1.414l-.707.707a1 1 0 001.414 1.414zM3 11a1 1 0 100 2h1a1 1 0 100-2H3zM15 11a1 1 0 100-2h1a1 1 0 100 2h-1z" clip-rule="evenodd"></path></svg>
                </button>
                <button @click="openMobileMenu = !openMobileMenu" style="color: var(--clr-header-text);" class="opacity-75 hover:opacity-100 focus:outline-none" aria-label="Open mobile menu">
                    <svg x-show="!openMobileMenu" class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16"></path></svg>
                    <svg x-show="openMobileMenu" class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path></svg>
                </button>
            </div>
        </div>

        {{-- Mobile Menu --}}
        <div x-show="openMobileMenu"
             x-transition:enter="transition ease-out duration-200"
             x-transition:enter-start="opacity-0 transform -translate-y-2"
             x-transition:enter-end="opacity-100 transform translate-y-0"
             x-transition:leave="transition ease-in duration-150"
             x-transition:leave-start="opacity-100 transform translate-y-0"
             x-transition:leave-end="opacity-0 transform -translate-y-2"
             @click.outside="openMobileMenu = false" {{-- .away is deprecated, use .outside --}}
             style="background-color: var(--clr-header-bg); color: var(--clr-header-text);"
             class="md:hidden absolute top-full start-0 w-full shadow-xl py-2 border-t border-gray-200 dark:border-gray-700"
             x-cloak>
            @if($primaryMenu && $primaryMenu->rootItems->isNotEmpty())
                @foreach($primaryMenu->rootItems as $item)
                    {{-- Mobile menu usually doesn't have deep nesting, so direct link or simple children list --}}
                    <a href="{{ $item->link }}" target="{{ $item->target }}" style="color: var(--clr-header-text);" class="block px-4 py-3 text-base font-medium hover:bg-gray-100 dark:hover:bg-gray-700 hover:text-[var(--clr-accent)] dark:hover:text-[var(--clr-accent)] text-start">
                        @if($item->icon_class)<i class="{{ $item->icon_class }} me-2"></i>@endif
                        {{ $item->title }}
                    </a>
                @endforeach
            @else
                <a href="{{ url('/') }}" style="color: var(--clr-header-text);" class="block px-4 py-3 text-base font-medium hover:bg-gray-100 dark:hover:bg-gray-700 hover:text-[var(--clr-accent)] dark:hover:text-[var(--clr-accent)]">Home</a>
            @endif
        </div>
    </div>
</header>
