{{--
    Generic Default Layout
    Expects $section and $content (which is $section->content)
    Tries to render common fields like title, subtitle, text_content, image_url, button_text, button_link
--}}
<section id="section-{{ $section->id }}" class="py-12 md:py-20 {{ $content['bg_color'] ?? 'bg-white dark:bg-gray-800' }} {{ $content['text_color'] ?? 'text-gray-800 dark:text-gray-200' }}">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        @if(!empty($content['title']))
            <h2 class="text-3xl md:text-4xl font-bold {{ $content['title_align'] ?? 'text-center' }} mb-4">{{ $content['title'] }}</h2>
        @endif
        @if(!empty($content['subtitle']))
            <p class="text-lg {{ $content['subtitle_align'] ?? 'text-center' }} text-gray-600 dark:text-gray-400 mb-8 max-w-2xl {{ ($content['subtitle_align'] ?? 'text-center') == 'text-center' ? 'mx-auto' : '' }}">{{ $content['subtitle'] }}</p>
        @endif

        @if(!empty($content['image_url']))
            <img src="{{ $content['image_url'] }}" alt="{{ $content['image_alt'] ?? $content['title'] ?? 'Section Image' }}" class="mx-auto rounded-lg shadow-lg mb-8 max-w-full h-auto {{ $content['image_class'] ?? '' }}">
        @endif

        @if(!empty($content['text_content']))
            <div class="prose prose-lg lg:prose-xl dark:prose-invert max-w-none mx-auto {{ $content['text_content_align'] ?? '' }}">{!! $content['text_content'] !!}</div>
        @endif

        @if(!empty($content['button_text']) && !empty($content['button_link']))
            <div class="mt-8 {{ $content['button_align'] ?? 'text-center' }}">
                <a href="{{ $content['button_link'] }}" class="inline-block bg-purple-600 hover:bg-purple-700 text-white font-semibold py-3 px-8 rounded-lg text-lg shadow-md hover:shadow-lg transition-all duration-300 {{ $content['button_class'] ?? '' }}">
                    {{ $content['button_text'] }}
                </a>
            </div>
        @endif
    </div>
</section>