@props([
    'project' => null, // Expects a Project model/object or an LpPage object representing a project
    'canyonLink' => null, // Optional direct link to CodeCanyon
])

@if($project)
    @php
        // Determine the link for the project.
        // If it's an LpPage, link to its detail page. Otherwise, use canyonLink or a generic detail route.
        $projectDetailUrl = '#'; // Default
        if ($project instanceof \Modules\LandingPage\Entities\LpPage) {
            $projectDetailUrl = route('landingpage.page.show', $project->slug);
        } elseif (isset($project->slug) && Route::has('digitalvocano.projects.show')) { // Assuming a route for a dedicated Project module
            $projectDetailUrl = route('digitalvocano.projects.show', $project->slug);
        }

        $imageUrl = $project->featured_image_url ?? 'https://via.placeholder.com/400x300.png?text=' . urlencode($project->title ?? $project->name ?? 'Project');
        $projectName = $project->name ?? $project->title ?? 'Unnamed Project';
        $shortDescription = $project->short_description ?? \Illuminate\Support\Str::limit(strip_tags($project->content ?? $project->description ?? ''), 100);
    @endphp
<div {{ $attributes->merge(['class' => 'group bg-white dark:bg-gray-800 rounded-xl shadow-lg hover:shadow-2xl transition-all duration-300 ease-in-out overflow-hidden flex flex-col']) }}>
    <a href="{{ $projectDetailUrl }}" class="block overflow-hidden h-56">
        <img src="{{ $imageUrl }}" alt="Featured image for {{ $projectName }}" class="w-full h-full object-cover transform group-hover:scale-105 transition-transform duration-500 ease-in-out">
    </a>
    <div class="p-6 flex flex-col flex-grow">
        <h3 class="text-xl font-semibold mb-2 text-gray-900 dark:text-white group-hover:text-purple-600 dark:group-hover:text-purple-400 transition-colors">
            <a href="{{ $projectDetailUrl }}">{{ $projectName }}</a>
        </h3>
        <p class="text-gray-600 dark:text-gray-400 text-sm mb-4 line-clamp-3 flex-grow">{{ $shortDescription }}</p>
        <div class="mt-auto">
            <a href="{{ $projectDetailUrl }}" class="inline-flex items-center text-purple-600 dark:text-purple-400 hover:text-purple-700 dark:hover:text-purple-300 font-semibold text-sm group-hover:translate-x-1 transition-transform">
                View Details <svg class="w-4 h-4 ml-1.5" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3"></path></svg>
            </a>
            @if($canyonLink || ($project->canyon_url ?? null))
            <a href="{{ $canyonLink ?? $project->canyon_url }}" target="_blank" rel="noopener noreferrer" class="ml-4 inline-flex items-center text-green-600 dark:text-green-400 hover:text-green-700 dark:hover:text-green-300 font-semibold text-sm">
                Buy on CodeCanyon <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 ml-1.5" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2"><path stroke-linecap="round" stroke-linejoin="round" d="M10 6H6a2 2 0 00-2 2v10a2 2 0 002 2h10a2 2 0 002-2v-4M14 4h6m0 0v6m0-6L10 14" /></svg>
            </a>
            @endif
        </div>
    </div>
</div>
@endif