{{--
    $item: The MenuItem instance.
    $level: Current depth of the menu item (0 for root).
--}}
@php
    $level = $level ?? 0; // Ensure $level is set, default to 0 if not passed
    $hasChildren = $item->children->isNotEmpty();
    $itemLink = $item->link ?? '#'; // Ensure $itemLink is always defined

    // Active state determination
    $isActive = false;
    if ($itemLink !== '#') {
        // Normalize current URL and item link by removing trailing slashes for comparison
        $currentFullUrl = rtrim(request()->fullUrl(), '/');
        $normalizedItemLink = rtrim($itemLink, '/');
        $baseAppUrl = rtrim(url('/'), '/');

        if ($currentFullUrl === $normalizedItemLink) {
            // Exact match (e.g., current /about matches item /about)
            $isActive = true;
        } elseif ($normalizedItemLink !== $baseAppUrl && Str::startsWith($currentFullUrl, $normalizedItemLink . '/')) {
            // Current URL starts with the item link (e.g., item /blog matches current /blog/post-title)
            // This check is avoided if the item link is the base app URL to prevent it from matching all sub-pages.
            $isActive = true;
        } elseif (request()->is('/') && $normalizedItemLink === $baseAppUrl) {
            // Explicit homepage match (current is / and item link is the base app URL)
            $isActive = true;
        }
    }

    // Define classes and styles based on active state and level
    $linkClasses = "block px-3 py-2 rounded-md text-sm font-medium transition-colors duration-150 ease-in-out hover:bg-gray-100 dark:hover:bg-gray-700 hover:text-[var(--clr-accent)] dark:hover:text-[var(--clr-accent)]";
    $linkClasses .= ($level > 0 ? ' w-full text-left' : ' inline-block');

    $activeStyle = "background-color: color-mix(in srgb, var(--clr-accent) 15%, transparent); color: var(--clr-accent);";
    $inactiveStyle = "color: var(--clr-header-text);";
    $currentLinkStyle = $isActive ? $activeStyle : $inactiveStyle;

    // Style for the chevron icon, should also reflect active state
    $chevronIconStyle = $isActive ? 'color: var(--clr-accent);' : 'color: var(--clr-header-text);';
@endphp

<li class="{{ $hasChildren && $level < 2 ? 'relative group' : '' }} {{ $level > 0 ? 'w-full' : '' }}">
    <a href="{{ $itemLink }}"
       target="{{ $item->target }}"
       style="{{ $currentLinkStyle }}"
       class="{{ $linkClasses }}">
        @if($item->icon_class)<i class="{{ $item->icon_class }} mr-2"></i>@endif
        {{ $item->title }}
        @if($hasChildren && $level < 1) {{-- Show dropdown icon only for top level with children --}}
            <i class="fas fa-chevron-down ml-1 text-xs opacity-70 group-hover:opacity-100 transition-opacity" style="{{ $chevronIconStyle }}"></i>
        @endif
    </a>
    @if ($hasChildren && $level < 2) {{-- Limit dropdowns to 2 levels for simplicity in this example --}}
        <ul style="background-color: var(--clr-header-bg); border-color: color-mix(in srgb, var(--clr-header-text) 20%, transparent);"
            class="absolute w-56 rounded-md shadow-lg py-1 hidden group-hover:block z-50 border
                   {{ $level === 0 ? 'left-0 top-full' : '' }}
                   {{ $level === 1 ? 'left-full top-0 border-l' : '' }}
                   ">
            @foreach ($item->children as $child)
                            <x-landingpage::themes.general.partials.menu-item-frontend :item="$child" :level="$level + 1" />
            @endforeach
        </ul>
    @endif
</li>