@props([
    'company' => null, // Expects a Company model/object
])

@if($company)
<div {{ $attributes->merge(['class' => 'bg-white dark:bg-gray-800 shadow-lg rounded-lg overflow-hidden hover:shadow-xl transition-shadow duration-300']) }}>
    @if($company->logo_url) {{-- Assuming your Company model has a logo_url accessor or property --}}
        <a href="{{ route('landingpage.page.show', $company->slug) }}" class="block h-48 bg-gray-200 dark:bg-gray-700">
            <img src="{{ $company->logo_url }}" alt="{{ $company->name }} logo" class="w-full h-full object-contain p-4">
        </a>
    @else
        <a href="{{ route('landingpage.page.show', $company->slug) }}" class="block h-48 bg-gray-300 dark:bg-gray-700 flex items-center justify-center text-gray-500">
            <svg class="w-16 h-16" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"></path></svg>
        </a>
    @endif
    <div class="p-6">
        <h3 class="text-xl font-semibold mb-2 text-gray-900 dark:text-white">
            <a href="{{ route('landingpage.page.show', $company->slug) }}" class="hover:text-purple-600 dark:hover:text-purple-400">{{ $company->name }}</a>
        </h3>
        <p class="text-gray-600 dark:text-gray-400 text-sm mb-3 line-clamp-3">{{ $company->short_description ?? 'Learn more about this company.' }}</p>
        <a href="{{ route('landingpage.page.show', $company->slug) }}" class="text-purple-600 dark:text-purple-400 hover:underline font-medium text-sm">View Profile &rarr;</a>
    </div>
</div>
@endif