@props([
    'iconSvg' => '', // Slot for SVG or path to an image
    'title' => 'Feature Title',
    'description' => 'Detailed description of the feature and its benefits.'
])

<div {{ $attributes->merge(['class' => 'bg-gray-800/50 dark:bg-gray-900/70 p-8 rounded-xl shadow-2xl border border-gray-700 dark:border-gray-800 hover:border-blue-500 dark:hover:border-blue-400 transition-all duration-300 transform hover:-translate-y-1']) }}>
    @if($iconSvg)
    <div class="text-blue-400 dark:text-blue-300 mb-6 inline-flex items-center justify-center w-16 h-16 bg-gray-700 dark:bg-gray-800 rounded-full">
        {!! $iconSvg !!}
    </div>
    @endif
    <h3 class="text-xl font-semibold mb-3 text-white">{{ $title }}</h3>
    <p class="text-gray-400 dark:text-gray-300 text-sm leading-relaxed">{{ $description }}</p>
</div>
