@extends('landingpage::layouts.admin')

@section('title', 'Landing Page Dashboard')
@push('module_styles')
{{-- Module-specific styles can be pushed here if needed, though Tailwind aims to minimize this. --}}
@endpush

@section('module_content')
<div class="px-4 sm:px-6 lg:px-8 py-8 w-full max-w-9xl mx-auto"> {{-- Consistent padding and max-width --}}
    <div class="sm:flex sm:justify-between sm:items-center mb-8">
        <h1 class="text-2xl md:text-3xl text-slate-800 dark:text-slate-100 font-bold">Landing Page Management</h1>
        <a href="{{ route('admin.landingpage.pages.create') }}" class="mt-4 sm:mt-0 inline-flex items-center px-6 py-3 bg-blue-600 border border-transparent rounded-md font-semibold text-sm text-white uppercase tracking-widest hover:bg-blue-700 active:bg-blue-800 focus:outline-none focus:border-blue-900 focus:ring-2 focus:ring-blue-500 focus:ring-offset-2 disabled:opacity-50 transition ease-in-out duration-150">
            <i class="fas fa-plus mr-2"></i> Create New Page
        </a>
    </div>

    <nav class="mb-6 text-sm" aria-label="Breadcrumb">
        <ol class="list-none p-0 inline-flex">
            <li class="flex items-center">
                <a href="{{ route('admin.dashboard') }}" class="text-blue-500 hover:text-blue-700 hover:underline dark:text-blue-400 dark:hover:text-blue-300">Dashboard</a>
                <svg class="fill-current w-3 h-3 mx-3 text-slate-400 dark:text-slate-500" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 320 512"><path d="M285.476 272.971L91.132 467.314c-9.373 9.373-24.569 9.373-33.941 0l-22.667-22.667c-9.357-9.357-9.375-24.522-.04-33.901L188.505 256 34.484 101.255c-9.335-9.379-9.317-24.544.04-33.901l22.667-22.667c9.373-9.373 24.569-9.373 33.941 0L285.475 239.03c9.373 9.372 9.373 24.568.001 33.941z"/></svg>
            </li>
            <li class="flex items-center">
                <span class="text-slate-500 dark:text-slate-400">Landing Pages</span>
            </li>
    </ol>

    @if(session('success'))
        <div class="mb-6 p-4 bg-green-50 border-l-4 border-green-400 text-green-700 rounded-md relative" role="alert">
            <strong class="font-bold">Success!</strong>
            <span>{{ session('success') }}</span>
            <button type="button" class="absolute top-0 bottom-0 right-0 px-4 py-3 text-green-700 hover:text-green-900" data-dismiss="alert" aria-label="Close" onclick="this.parentElement.style.display='none';">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    @endif
    @if(session('error'))
        <div class="mb-6 p-4 bg-red-50 border-l-4 border-red-400 text-red-700 rounded-md relative" role="alert">
            <strong class="font-bold">Error!</strong>
            <span>{{ session('error') }}</span>
            <button type="button" class="absolute top-0 bottom-0 right-0 px-4 py-3 text-red-700 hover:text-red-900" data-dismiss="alert" aria-label="Close" onclick="this.parentElement.style.display='none';">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    @endif

    <!-- Summary Cards -->
    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
        {{-- Stat Card: Total Pages --}}
        <div class="bg-white dark:bg-slate-800 overflow-hidden shadow-lg rounded-lg">
            <div class="p-5">
                <div class="flex items-center">
                    <div class="flex-shrink-0 bg-blue-500 dark:bg-blue-700 rounded-md p-3">
                        <i class="fas fa-file-alt h-6 w-6 text-white"></i>
                    </div>
                    <div class="ml-5 w-0 flex-1">
                        <dl>
                            <dt class="text-sm font-medium text-slate-500 dark:text-slate-400 truncate">
                                Total Pages
                            </dt>
                            <dd class="text-2xl font-semibold text-slate-900 dark:text-white">
                                {{ $stats['total_pages'] ?? 0 }}
                            </dd>
                        </dl>
                    </div>
                </div>
            </div>
            <div class="bg-slate-50 dark:bg-slate-700 px-5 py-3">
                <div class="text-sm">
                    <a href="{{ route('admin.landingpage.pages.index') }}" class="font-medium text-blue-600 dark:text-blue-400 hover:text-blue-500 dark:hover:text-blue-300">
                        View all
                    </a>
                </div>
            </div>
        </div>

        {{-- Stat Card: Published Pages --}}
        <div class="bg-white dark:bg-slate-800 overflow-hidden shadow-lg rounded-lg">
            <div class="p-5">
                <div class="flex items-center">
                    <div class="flex-shrink-0 bg-green-500 dark:bg-green-700 rounded-md p-3">
                        <i class="fas fa-check-circle h-6 w-6 text-white"></i>
                    </div>
                    <div class="ml-5 w-0 flex-1">
                        <dl>
                            <dt class="text-sm font-medium text-slate-500 dark:text-slate-400 truncate">
                                Published Pages
                            </dt>
                            <dd class="text-2xl font-semibold text-slate-900 dark:text-white">
                                {{ $stats['published_pages'] ?? 0 }}
                            </dd>
                        </dl>
                    </div>
                </div>
            </div>
            <div class="bg-slate-50 dark:bg-slate-700 px-5 py-3">
                <div class="text-sm">
                    <a href="{{ route('admin.landingpage.pages.index', ['filter[is_published]' => '1']) }}" class="font-medium text-green-600 dark:text-green-400 hover:text-green-500 dark:hover:text-green-300">
                        View published
                    </a>
                </div>
            </div>
        </div>

        {{-- Stat Card: Draft Pages --}}
        <div class="bg-white dark:bg-slate-800 overflow-hidden shadow-lg rounded-lg">
            <div class="p-5">
                <div class="flex items-center">
                    <div class="flex-shrink-0 bg-yellow-500 dark:bg-yellow-600 rounded-md p-3"> {{-- Adjusted yellow for better contrast in dark mode --}}
                        <i class="fas fa-pencil-ruler h-6 w-6 text-white"></i>
                    </div>
                    <div class="ml-5 w-0 flex-1">
                        <dl>
                            <dt class="text-sm font-medium text-slate-500 dark:text-slate-400 truncate">
                                Draft Pages
                            </dt>
                            <dd class="text-2xl font-semibold text-slate-900 dark:text-white">
                                {{ $stats['draft_pages'] ?? 0 }}
                            </dd>
                        </dl>
                    </div>
                </div>
            </div>
            <div class="bg-slate-50 dark:bg-slate-700 px-5 py-3">
                <div class="text-sm">
                    <a href="{{ route('admin.landingpage.pages.index', ['filter[is_published]' => '0']) }}" class="font-medium text-yellow-600 dark:text-yellow-400 hover:text-yellow-500 dark:hover:text-yellow-300">
                        View drafts
                    </a>
                </div>
            </div>
        </div>

        {{-- Quick Link: Theme Settings --}}
        <div class="bg-white dark:bg-slate-800 overflow-hidden shadow-lg rounded-lg">
            <div class="p-5">
                <div class="flex items-center">
                    <div class="flex-shrink-0 bg-sky-500 dark:bg-sky-700 rounded-md p-3">
                        <i class="fas fa-palette h-6 w-6 text-white"></i>
                    </div>
                    <div class="ml-5 w-0 flex-1">
                        <dl>
                            <dt class="text-sm font-medium text-slate-500 dark:text-slate-400 truncate">
                                Theme Settings
                            </dt>
                            <dd class="text-lg font-semibold text-slate-900 dark:text-white">
                                Customize Look
                            </dd>
                        </dl>
                    </div>
                </div>
            </div>
            <div class="bg-slate-50 dark:bg-slate-700 px-5 py-3">
                <div class="text-sm">
                    <a href="{{ route('admin.landingpage.theme.settings.edit') }}" class="font-medium text-sky-600 dark:text-sky-400 hover:text-sky-500 dark:hover:text-sky-300">
                        Go to settings <i class="fas fa-arrow-right ml-1"></i>
                    </a>
                </div>
            </div>
        </div>

        {{-- Quick Link: Manage Menus --}}
        <div class="bg-white dark:bg-slate-800 overflow-hidden shadow-lg rounded-lg">
            <div class="p-5">
                <div class="flex items-center">
                    <div class="flex-shrink-0 bg-purple-500 dark:bg-purple-700 rounded-md p-3">
                        <i class="fas fa-bars h-6 w-6 text-white"></i>
                    </div>
                    <div class="ml-5 w-0 flex-1">
                        <dl>
                            <dt class="text-sm font-medium text-slate-500 dark:text-slate-400 truncate">
                                Menu Management
                            </dt>
                            <dd class="text-lg font-semibold text-slate-900 dark:text-white">
                                Manage Menus
                            </dd>
                        </dl>
                    </div>
                </div>
            </div>
            <div class="bg-slate-50 dark:bg-slate-700 px-5 py-3">
                <div class="text-sm">
                    <a href="{{ route('admin.landingpage.menus.index') }}" class="font-medium text-purple-600 dark:text-purple-400 hover:text-purple-500 dark:hover:text-purple-300">
                        Go to menus <i class="fas fa-arrow-right ml-1"></i>
                    </a>
                </div>
            </div>
        </div>
    </div>

    {{-- Google Analytics Summary --}}
    @if(isset($gaStats) && setting('google_analytics_enable_tracking', false) && setting('google_analytics_property_id'))
    <div class="mb-8">
        <h2 class="text-xl font-semibold text-slate-700 dark:text-slate-100 mb-4"><i class="fab fa-google mr-2 text-blue-500"></i>Google Analytics Summary (Last 7 Days)</h2>
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
            {{-- Users Card --}}
            <div class="bg-white dark:bg-slate-800 overflow-hidden shadow-lg rounded-lg p-5">
                <div class="flex items-center">
                    <div class="flex-shrink-0 bg-teal-500 dark:bg-teal-700 rounded-md p-3">
                        <i class="fas fa-users h-6 w-6 text-white"></i>
                    </div>
                    <div class="ml-5 w-0 flex-1">
                        <dl>
                            <dt class="text-sm font-medium text-slate-500 dark:text-slate-400 truncate">Total Users</dt>
                            <dd class="text-2xl font-semibold text-slate-900 dark:text-white">{{ $gaStats['users'] ?? 'N/A' }}</dd>
                        </dl>
                    </div>
                </div>
            </div>
            {{-- Page Views Card --}}
            <div class="bg-white dark:bg-slate-800 overflow-hidden shadow-lg rounded-lg p-5">
                <div class="flex items-center">
                    <div class="flex-shrink-0 bg-pink-500 dark:bg-pink-700 rounded-md p-3">
                        <i class="fas fa-eye h-6 w-6 text-white"></i>
                    </div>
                    <div class="ml-5 w-0 flex-1">
                        <dl>
                            <dt class="text-sm font-medium text-slate-500 dark:text-slate-400 truncate">Page Views</dt>
                            <dd class="text-2xl font-semibold text-slate-900 dark:text-white">{{ $gaStats['pageViews'] ?? 'N/A' }}</dd>
                        </dl>
                    </div>
                </div>
            </div>
            {{-- Sessions Card --}}
            <div class="bg-white dark:bg-slate-800 overflow-hidden shadow-lg rounded-lg p-5">
                <div class="flex items-center">
                    <div class="flex-shrink-0 bg-amber-500 dark:bg-amber-700 rounded-md p-3">
                        <i class="fas fa-hourglass-half h-6 w-6 text-white"></i>
                    </div>
                    <div class="ml-5 w-0 flex-1">
                        <dl>
                            <dt class="text-sm font-medium text-slate-500 dark:text-slate-400 truncate">Sessions</dt>
                            <dd class="text-2xl font-semibold text-slate-900 dark:text-white">{{ $gaStats['sessions'] ?? 'N/A' }}</dd>
                        </dl>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @elseif(setting('google_analytics_enable_tracking', false) && !setting('google_analytics_property_id'))
    <div class="mb-6 p-4 bg-yellow-50 border-l-4 border-yellow-400 text-yellow-700 dark:bg-yellow-900 dark:text-yellow-300 dark:border-yellow-600 rounded-md" role="alert">
        Google Analytics tracking is enabled, but the <strong>Property ID</strong> is not set. Statistics cannot be displayed. Please configure it in <a href="{{ route('admin.landingpage.theme.settings.edit') }}" class="font-semibold underline">Theme Settings</a>.
    </div>
    @endif

    {{-- Page List & Filters --}}
    <div class="bg-white dark:bg-slate-800 shadow-xl rounded-lg mb-8 overflow-x-auto">
        <div class="px-6 py-4 border-b border-slate-200 dark:border-slate-700 bg-slate-50 dark:bg-slate-700/50">
            <div class="flex justify-between items-center">
                <h2 class="text-xl font-semibold text-slate-700 dark:text-slate-100"><i class="fas fa-file-alt mr-2 text-blue-500"></i>All Pages</h2>
                {{-- Filter Form --}}
                <form action="{{ route('admin.landingpage.pages.index') }}" method="GET" class="flex items-center space-x-3">
                    <div class="relative">
                        <input type="text" name="search" value="{{ request('search') }}" placeholder="Search title or slug..."
                               class="form-input pl-9 pr-3 py-2 w-full sm:w-64 rounded-md border-slate-300 dark:border-slate-600 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm dark:bg-slate-700 dark:text-slate-200">
                        <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                            <i class="fas fa-search text-slate-400"></i>
                        </div>
                    </div>
                    <select name="status" class="form-select rounded-md border-slate-300 dark:border-slate-600 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm dark:bg-slate-700 dark:text-slate-200">
                        <option value="">All Statuses</option>
                        <option value="published" {{ request('status') == 'published' ? 'selected' : '' }}>Published</option>
                        <option value="draft" {{ request('status') == 'draft' ? 'selected' : '' }}>Draft</option>
                    </select>
                    <button type="submit" class="inline-flex items-center px-4 py-2 bg-slate-600 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-slate-700 active:bg-slate-800 focus:outline-none focus:border-slate-900 focus:ring ring-slate-300 disabled:opacity-25 transition ease-in-out duration-150">
                        Filter
                    </button>
                    @if(request()->has('search') || request()->has('status'))
                        <a href="{{ route('admin.landingpage.pages.index') }}" class="text-sm text-slate-500 hover:text-slate-700 dark:text-slate-400 dark:hover:text-slate-200 hover:underline">Clear</a>
                    @endif
                </form>
            </div>
        </div>
        <div class="p-0"> {{-- Removed p-0 if table has its own padding --}}
            @if($pages->isEmpty())
                <div class="text-center p-12 text-slate-500 dark:text-slate-400">
                    <i class="fas fa-folder-open fa-3x mb-3 text-slate-400"></i>
                    <p class="text-lg">No pages found.</p>
                    @if(request()->has('search') || request()->has('status'))
                        <p class="mt-1">Try adjusting your filters or <a href="{{ route('admin.landingpage.pages.index') }}" class="text-blue-500 hover:underline font-semibold">clear filters</a>.</p>
                    @else
                        <p class="mt-1">Ready to get started? <a href="{{ route('admin.landingpage.pages.create') }}" class="text-blue-500 hover:underline font-semibold">Create your first page!</a></p>
                    @endif
                </div>
            @else
                <table class="min-w-full divide-y divide-slate-200 dark:divide-slate-700">
                    <thead class="bg-slate-50 dark:bg-slate-700/50">
                        <tr>
                            <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-slate-500 dark:text-slate-300 uppercase tracking-wider">Title</th>
                            <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-slate-500 dark:text-slate-300 uppercase tracking-wider">Slug</th>
                            <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-slate-500 dark:text-slate-300 uppercase tracking-wider">Status</th>
                            <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-slate-500 dark:text-slate-300 uppercase tracking-wider hidden md:table-cell">Last Updated</th>
                            <th scope="col" class="px-6 py-3 text-right text-xs font-medium text-slate-500 dark:text-slate-300 uppercase tracking-wider">Actions</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white dark:bg-slate-800 divide-y divide-slate-200 dark:divide-slate-700">
                        @foreach ($pages as $page)
                        <tr>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="text-sm font-medium text-slate-900 dark:text-slate-100 hover:text-blue-600 dark:hover:text-blue-400">
                                    <a href="{{ route('admin.landingpage.pages.edit', $page->id) }}">{{ $page->title }}</a>
                                </div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-slate-500 dark:text-slate-400">/{{ $page->slug }}</td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                @if ($page->is_published)
                                    <span class="px-2.5 py-0.5 inline-flex text-xs leading-5 font-semibold rounded-full bg-green-100 text-green-800 dark:bg-green-700 dark:text-green-100">Published</span>
                                @else
                                    <span class="px-2.5 py-0.5 inline-flex text-xs leading-5 font-semibold rounded-full bg-yellow-100 text-yellow-800 dark:bg-yellow-600 dark:text-yellow-100">Draft</span>
                                @endif
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-slate-500 dark:text-slate-400 hidden md:table-cell">{{ $page->updated_at->format('M d, Y H:i') }}</td>
                            <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium space-x-2">
                                <a href="{{ route('landingpage.page.show', $page->slug) }}" target="_blank" class="text-blue-500 hover:text-blue-700 dark:text-blue-400 dark:hover:text-blue-300 p-1" title="View Page">
                                    <i class="fas fa-eye"></i>
                                </a>
                                <a href="{{ route('admin.landingpage.pages.edit', $page->id) }}" class="text-indigo-600 hover:text-indigo-900 dark:text-indigo-400 dark:hover:text-indigo-300 p-1" title="Edit Page">
                                    <i class="fas fa-edit"></i>
                                </a>
                                <form action="{{ route('admin.landingpage.pages.destroy', $page->id) }}" method="POST" class="inline-block" onsubmit="return confirm('Are you sure you want to delete this page?');">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="text-red-600 hover:text-red-900 dark:text-red-400 dark:hover:text-red-300 p-1" title="Delete Page">
                                        <i class="fas fa-trash-alt"></i>
                                    </button>
                                </form>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
                <div class="px-6 py-4 border-t border-slate-200 dark:border-slate-700 bg-white dark:bg-slate-800">
                    {{ $pages->appends(request()->query())->links() }}
                </div>
            @endif
        </div>
    </div>

    {{-- Top Pages from Google Analytics --}}
    @if(isset($gaTopPages) && !empty($gaTopPages) && setting('google_analytics_enable_tracking', false))
    <div class="bg-white dark:bg-slate-800 shadow-xl rounded-lg mb-8 overflow-hidden">
        <div class="px-6 py-4 border-b border-slate-200 dark:border-slate-700 bg-slate-50 dark:bg-slate-700/50">
            <h2 class="text-xl font-semibold text-slate-700 dark:text-slate-100"><i class="fas fa-chart-line mr-2 text-green-500"></i>Top Pages (Last 7 Days)</h2>
        </div>
        <ul role="list" class="divide-y divide-slate-200 dark:divide-slate-700">
            @foreach ($gaTopPages as $topPage)
            <li class="hover:bg-slate-50 dark:hover:bg-slate-700/30 transition-colors duration-150">
                <div class="px-6 py-4 flex items-center justify-between space-x-4">
                    <div class="min-w-0 flex-1">
                        <p class="text-sm font-medium text-slate-700 dark:text-slate-200 truncate">{{ $topPage['path'] }}</p>
                    </div>
                    <div class="flex-shrink-0">
                        <span class="px-2.5 py-0.5 inline-flex text-xs leading-5 font-semibold rounded-full bg-blue-100 text-blue-800 dark:bg-blue-700 dark:text-blue-100">
                            {{ $topPage['views'] }} views
                        </span>
                    </div>
                </div>
            </li>
            @endforeach
        </ul>
    </div>
    @endif

    {{-- Section for Recently Updated Pages (Optional, can be removed if All Pages list is sufficient) --}}
    {{-- If you keep this, ensure $recentPages is passed from the controller if it's different from $pages --}}
    @if(isset($recentPages) && $recentPages->isNotEmpty() && !$pages->isNotEmpty()) {{-- Show only if main list is empty due to filters but recent exist --}}
    <div class="bg-white dark:bg-slate-800 shadow-xl rounded-lg mb-8 overflow-hidden">
        <div class="px-6 py-4 border-b border-slate-200 dark:border-slate-700 bg-slate-50 dark:bg-slate-700/50">
            <h2 class="text-xl font-semibold text-slate-700 dark:text-slate-100"><i class="fas fa-history mr-2 text-purple-500"></i>Recently Updated</h2>
        </div>
        <ul role="list" class="divide-y divide-slate-200 dark:divide-slate-700">
            @foreach ($recentPages as $page)
            <li class="hover:bg-slate-50 dark:hover:bg-slate-700/30 transition-colors duration-150">
                <div class="px-6 py-5 flex items-center justify-between space-x-4">
                    <div class="min-w-0 flex-1">
                        <a href="{{ route('admin.landingpage.pages.edit', $page->id) }}" class="text-base font-medium text-blue-600 dark:text-blue-400 hover:text-blue-800 dark:hover:text-blue-300 hover:underline truncate block">
                                        {{ $page->title }}
                                    </a>
                                    <p class="text-sm text-slate-500 dark:text-slate-400 truncate">/{{ $page->slug }}</p>
                                </div>
                                <div class="flex-shrink-0 flex items-center space-x-3">
                                    @if ($page->is_published)
                                        <span class="px-2.5 py-0.5 inline-flex text-xs leading-5 font-semibold rounded-full bg-green-100 text-green-800 dark:bg-green-700 dark:text-green-100">Published</span>
                                    @else
                                        <span class="px-2.5 py-0.5 inline-flex text-xs leading-5 font-semibold rounded-full bg-yellow-100 text-yellow-800 dark:bg-yellow-600 dark:text-yellow-100">Draft</span>
                                    @endif
                                    <p class="text-sm text-slate-500 dark:text-slate-400 hidden md:block">{{ $page->updated_at->diffForHumans() }}</p>
                                    <a href="{{ route('landingpage.page.show', $page->slug) }}" target="_blank" class="text-blue-500 hover:text-blue-700 dark:text-blue-400 dark:hover:text-blue-300 p-1" title="View Page">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                    <a href="{{ route('admin.landingpage.pages.edit', $page->id) }}" class="text-indigo-600 hover:text-indigo-900 dark:text-indigo-400 dark:hover:text-indigo-300 p-1" title="Edit Page">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                    <form action="{{ route('admin.landingpage.pages.destroy', $page->id) }}" method="POST" class="inline-block" onsubmit="return confirm('Are you sure you want to delete this page?');">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="text-red-600 hover:text-red-900 dark:text-red-400 dark:hover:text-red-300 p-1" title="Delete Page">
                                            <i class="fas fa-trash-alt"></i>
                                        </button>
                                    </form>
                                </div>
                            </div>
                        </li>
                @endforeach
                </ul>
    </div>
    @endif

    {{-- You can add more sections here, like quick links, charts, or other module-specific info --}}
</div>
@endsection

@push('module_scripts')
{{-- Add any page-specific JavaScript here if needed --}}
@endpush